/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.domain.model.SystemSettingsProvider;
import org.siouan.frontendgradleplugin.domain.usecase.IsNonProxyHost;
import org.siouan.frontendgradleplugin.domain.usecase.SelectProxySettings;

public class ResolveProxySettingsByUrl {
    private static final String FILE_PROTOCOL = "file";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private final SystemSettingsProvider systemSettingsProvider;
    private final IsNonProxyHost isNonProxyHost;
    private final SelectProxySettings selectProxySettings;

    public ResolveProxySettingsByUrl(@Nonnull SystemSettingsProvider systemSettingsProvider, @Nonnull IsNonProxyHost isNonProxyHost, @Nonnull SelectProxySettings selectProxySettings) {
        this.systemSettingsProvider = systemSettingsProvider;
        this.isNonProxyHost = isNonProxyHost;
        this.selectProxySettings = selectProxySettings;
    }

    @Nullable
    public ProxySettings execute(@Nullable String httpProxyHost, int httpProxyPort, @Nullable Credentials httpProxyCredentials, @Nullable String httpsProxyHost, int httpsProxyPort, @Nullable Credentials httpsProxyCredentials, @Nonnull URL resourceUrl) {
        String resourceProtocol = resourceUrl.getProtocol();
        if (resourceProtocol.equals(HTTP_PROTOCOL) || resourceProtocol.equals(HTTPS_PROTOCOL)) {
            if (this.isNonProxyHost.execute(this.systemSettingsProvider.getNonProxyHosts(), resourceUrl.getHost())) {
                return null;
            }
            if (resourceProtocol.equals(HTTPS_PROTOCOL)) {
                return this.selectProxySettings.execute(this.systemSettingsProvider.getHttpsProxyHost(), this.systemSettingsProvider.getHttpsProxyPort(), httpsProxyHost, httpsProxyPort, httpsProxyCredentials);
            }
            return this.selectProxySettings.execute(this.systemSettingsProvider.getHttpProxyHost(), this.systemSettingsProvider.getHttpProxyPort(), httpProxyHost, httpProxyPort, httpProxyCredentials);
        }
        if (resourceProtocol.equals(FILE_PROTOCOL)) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported protocol: " + resourceUrl.getProtocol());
    }
}

