/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;
import org.siouan.frontendgradleplugin.domain.usecase.AbstractGetExecutablePath;

public class GetNpxExecutablePath
extends AbstractGetExecutablePath {
    public static final Path WINDOWS_EXECUTABLE_FILE_NAME;
    public static final Path WINDOWS_EXECUTABLE_FILE_PATH;
    public static final Path NON_WINDOWS_EXECUTABLE_FILE_NAME;
    public static final Path NON_WINDOWS_EXECUTABLE_FILE_PATH;

    public GetNpxExecutablePath(FileManager fileManager, Logger logger) {
        super(fileManager, logger);
    }

    @Override
    @Nonnull
    protected Path getWindowsRelativeExecutablePath() {
        return WINDOWS_EXECUTABLE_FILE_PATH;
    }

    @Override
    @Nonnull
    protected Path getNonWindowsRelativeExecutablePath() {
        return NON_WINDOWS_EXECUTABLE_FILE_PATH;
    }

    @Override
    @Nonnull
    protected Optional<Path> getInstallDirectoryFromEnvironment(@Nonnull Platform platform) {
        return Optional.ofNullable(platform.getEnvironment().getNodeInstallDirectoryPath());
    }

    @Override
    @Nonnull
    protected Path getWindowsExecutableFileName() {
        return WINDOWS_EXECUTABLE_FILE_NAME;
    }

    @Override
    @Nonnull
    protected Path getNonWindowsExecutableFileName() {
        return NON_WINDOWS_EXECUTABLE_FILE_NAME;
    }

    static {
        WINDOWS_EXECUTABLE_FILE_PATH = WINDOWS_EXECUTABLE_FILE_NAME = Paths.get("npx.cmd", new String[0]);
        NON_WINDOWS_EXECUTABLE_FILE_NAME = Paths.get("npx", new String[0]);
        NON_WINDOWS_EXECUTABLE_FILE_PATH = Paths.get("bin", new String[0]).resolve(NON_WINDOWS_EXECUTABLE_FILE_NAME);
    }
}

