/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.siouan.frontendgradleplugin.domain.exception.FrontendException;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.InstallSettings;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.domain.usecase.AbstractInstallDistribution;
import org.siouan.frontendgradleplugin.domain.usecase.ResolveProxySettingsByUrl;
import org.siouan.frontendgradleplugin.infrastructure.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.Beans;

public abstract class AbstractDistributionInstallTask
extends DefaultTask {
    private final Property<String> httpProxyHost = this.getProject().getObjects().property(String.class);
    private final Property<Integer> httpProxyPort = this.getProject().getObjects().property(Integer.class);
    private final Property<String> httpProxyUsername = this.getProject().getObjects().property(String.class);
    private final Property<String> httpProxyPassword = this.getProject().getObjects().property(String.class);
    private final Property<String> httpsProxyHost = this.getProject().getObjects().property(String.class);
    private final Property<Integer> httpsProxyPort = this.getProject().getObjects().property(Integer.class);
    private final Property<String> httpsProxyUsername = this.getProject().getObjects().property(String.class);
    private final Property<String> httpsProxyPassword = this.getProject().getObjects().property(String.class);

    protected AbstractDistributionInstallTask() {
    }

    @Internal
    public Property<String> getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Internal
    public Property<Integer> getHttpProxyPort() {
        return this.httpProxyPort;
    }

    @Internal
    public Property<String> getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    @Internal
    public Property<String> getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    @Internal
    public Property<String> getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    @Internal
    public Property<Integer> getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    @Internal
    public Property<String> getHttpsProxyUsername() {
        return this.httpsProxyUsername;
    }

    @Internal
    public Property<String> getHttpsProxyPassword() {
        return this.httpsProxyPassword;
    }

    @TaskAction
    public void execute() throws BeanRegistryException, FrontendException, IOException {
        Credentials distributionServerCredentials = this.getDistributionServerCredentials();
        Credentials httpProxyCredentials = (Credentials)this.httpProxyUsername.map(username -> new Credentials((String)username, (String)this.httpProxyPassword.get())).getOrNull();
        Credentials httpsProxyCredentials = (Credentials)this.httpsProxyUsername.map(username -> new Credentials((String)username, (String)this.httpsProxyPassword.get())).getOrNull();
        String beanRegistryId = this.getProject().getPath();
        Beans.getBean(beanRegistryId, this.getInstallDistributionClass()).execute(this.getInstallSettings(Beans.getBean(beanRegistryId, Platform.class), distributionServerCredentials, Beans.getBean(beanRegistryId, ResolveProxySettingsByUrl.class).execute((String)this.httpProxyHost.getOrNull(), (Integer)this.httpProxyPort.get(), httpProxyCredentials, (String)this.httpsProxyHost.getOrNull(), (Integer)this.httpsProxyPort.get(), httpsProxyCredentials, new URL(this.getDistributionUrlRoot()))));
    }

    @Internal
    @Nullable
    protected abstract Credentials getDistributionServerCredentials();

    @Internal
    @Nonnull
    protected abstract Class<? extends AbstractInstallDistribution> getInstallDistributionClass();

    @Internal
    @Nonnull
    protected abstract String getDistributionUrlRoot();

    @Nonnull
    protected abstract InstallSettings getInstallSettings(@Nonnull Platform var1, @Nullable Credentials var2, @Nullable ProxySettings var3);
}

