/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SystemUtils {
    private static final String JVM_ARCH_PROPERTY = "os.arch";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String NON_PROXY_HOSTS_SPLIT_PATTERN = Pattern.quote("|");
    private static final String OS_NAME_PROPERTY = "os.name";

    private SystemUtils() {
    }

    @Nonnull
    public static Set<String> getNonProxyHosts() {
        String nonProxyHosts = System.getProperty(NON_PROXY_HOSTS);
        return nonProxyHosts == null || nonProxyHosts.trim().isEmpty() ? Collections.emptySet() : new HashSet<String>(Arrays.asList(nonProxyHosts.split(NON_PROXY_HOSTS_SPLIT_PATTERN)));
    }

    @Nullable
    public static String getHttpProxyHost() {
        return System.getProperty(HTTP_PROXY_HOST);
    }

    public static Optional<Integer> getHttpProxyPort() {
        String httpProxyPort = System.getProperty(HTTP_PROXY_PORT);
        return Optional.ofNullable(httpProxyPort).filter(port -> !port.trim().isEmpty()).map(Integer::parseInt);
    }

    @Nullable
    public static String getHttpsProxyHost() {
        return System.getProperty(HTTPS_PROXY_HOST);
    }

    public static Optional<Integer> getHttpsProxyPort() {
        String httpsProxyPort = System.getProperty(HTTPS_PROXY_PORT);
        return Optional.ofNullable(httpsProxyPort).filter(port -> !port.trim().isEmpty()).map(Integer::parseInt);
    }

    @Nonnull
    public static String getSystemJvmArch() {
        return SystemUtils.getPropertyAndAssertNotNull(JVM_ARCH_PROPERTY);
    }

    @Nonnull
    public static String getSystemOsName() {
        return SystemUtils.getPropertyAndAssertNotNull(OS_NAME_PROPERTY);
    }

    @Nonnull
    private static String getPropertyAndAssertNotNull(@Nonnull String property) {
        return Objects.requireNonNull(System.getProperty(property), "Unexpected <null> value when reading system property: " + property);
    }
}

