/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.exception.ArchiverException;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedDistributionArchiveException;
import org.siouan.frontendgradleplugin.domain.model.DeploymentSettings;
import org.siouan.frontendgradleplugin.domain.model.ExplodeSettings;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.provider.ArchiverProvider;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;

public class DeployDistribution {
    private final FileManager fileManager;
    private final ArchiverProvider archiverProvider;
    private final Logger logger;

    public DeployDistribution(FileManager fileManager, ArchiverProvider archiverProvider, Logger logger) {
        this.fileManager = fileManager;
        this.archiverProvider = archiverProvider;
        this.logger = logger;
    }

    public void execute(@Nonnull DeploymentSettings deploymentSettings) throws UnsupportedDistributionArchiveException, ArchiverException, IOException {
        Set distributionFilePaths;
        Path distributionFilePath = deploymentSettings.getDistributionFilePath();
        Path extractDirectoryPath = this.fileManager.createDirectory(deploymentSettings.getExtractDirectoryPath());
        this.logger.info("Exploding distribution into '{}'", extractDirectoryPath);
        ExplodeSettings explodeSettings = new ExplodeSettings(deploymentSettings.getPlatform(), distributionFilePath, extractDirectoryPath);
        this.archiverProvider.findByArchiveFilePath(distributionFilePath).orElseThrow(() -> new UnsupportedDistributionArchiveException(distributionFilePath)).explode(explodeSettings);
        this.logger.info("Moving distribution into '{}'", deploymentSettings.getInstallDirectoryPath());
        try (Stream<Path> childFilePaths = this.fileManager.list(extractDirectoryPath);){
            distributionFilePaths = childFilePaths.collect(Collectors.toSet());
        }
        Path distributionRootDirectoryPath = distributionFilePaths.size() == 1 ? (Path)distributionFilePaths.iterator().next() : extractDirectoryPath;
        this.fileManager.moveFileTree(distributionRootDirectoryPath, deploymentSettings.getInstallDirectoryPath());
        this.logger.info("Removing explode directory '{}'", extractDirectoryPath);
        this.fileManager.deleteIfExists(extractDirectoryPath);
    }
}

