/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.httpclient;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.siouan.frontendgradleplugin.domain.model.HttpResponse;

public class ApacheHttpResponse
implements HttpResponse {
    private final CloseableHttpClient httpClient;
    private final CloseableHttpResponse httpResponse;

    public ApacheHttpResponse(@Nonnull CloseableHttpClient httpClient, @Nonnull CloseableHttpResponse httpResponse) {
        this.httpClient = httpClient;
        this.httpResponse = httpResponse;
    }

    @Override
    @Nonnull
    public String getProtocol() {
        return this.httpResponse.getStatusLine().getProtocolVersion().getProtocol();
    }

    @Override
    @Nonnull
    public String getVersion() {
        return this.httpResponse.getStatusLine().getProtocolVersion().getMajor() + "." + this.httpResponse.getStatusLine().getProtocolVersion().getMinor();
    }

    @Override
    public int getStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    @Override
    @Nonnull
    public String getReasonPhrase() {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    @Override
    @Nonnull
    public InputStream getInputStream() throws IOException {
        HttpEntity httpEntity = this.httpResponse.getEntity();
        if (httpEntity == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return httpEntity.getContent();
    }

    @Override
    public void close() throws IOException {
        this.httpResponse.close();
        this.httpClient.close();
    }
}

