/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;

public class FileManagerImpl
implements FileManager {
    @Override
    public long copy(@Nonnull InputStream inputStream, @Nonnull Path filePath) throws IOException {
        return Files.copy(inputStream, filePath, new CopyOption[0]);
    }

    @Override
    public void copyFileTree(@Nonnull Path sourcePath, @Nonnull Path targetPath) throws IOException {
        Files.walkFileTree(sourcePath, new FileCopyVisitor(sourcePath, targetPath));
    }

    @Override
    @Nonnull
    public Path createDirectories(@Nonnull Path path) throws IOException {
        return Files.createDirectories(path, new FileAttribute[0]);
    }

    @Override
    @Nonnull
    public Path createDirectory(@Nonnull Path directoryPath) throws IOException {
        return Files.createDirectory(directoryPath, new FileAttribute[0]);
    }

    @Override
    @Nonnull
    public Path createSymbolicLink(@Nonnull Path linkFilePath, @Nonnull Path targetFilePath) throws IOException {
        return Files.createSymbolicLink(linkFilePath, targetFilePath, new FileAttribute[0]);
    }

    @Override
    public void delete(@Nonnull Path path) throws IOException {
        Files.delete(path);
    }

    @Override
    public boolean deleteIfExists(@Nonnull Path path) throws IOException {
        return Files.deleteIfExists(path);
    }

    @Override
    public void deleteFileTree(@Nonnull Path rootPath, boolean deleteRootEnabled) throws IOException {
        if (Files.exists(rootPath, new LinkOption[0])) {
            Files.walkFileTree(rootPath, new FileDeleteVisitor(rootPath, deleteRootEnabled));
        }
    }

    @Override
    public boolean exists(@Nonnull Path filePath) {
        return Files.exists(filePath, new LinkOption[0]);
    }

    @Override
    public boolean isDirectory(@Nonnull Path filePath) {
        return Files.isDirectory(filePath, new LinkOption[0]);
    }

    @Override
    public boolean isSameFile(@Nonnull Path path1, @Nonnull Path path2) throws IOException {
        return Files.isSameFile(path1, path2);
    }

    @Override
    @Nonnull
    public Stream<Path> list(@Nonnull Path directoryPath) throws IOException {
        return Files.list(directoryPath);
    }

    @Override
    @Nonnull
    public Path move(@Nonnull Path sourcePath, @Nonnull Path targetPath, CopyOption ... options) throws IOException {
        return Files.move(sourcePath, targetPath, options);
    }

    @Override
    @Nonnull
    public BufferedReader newBufferedReader(@Nonnull Path filePath) throws IOException {
        return Files.newBufferedReader(filePath);
    }

    @Override
    @Nonnull
    public InputStream newInputStream(@Nonnull Path filePath) throws IOException {
        return Files.newInputStream(filePath, new OpenOption[0]);
    }

    @Override
    @Nonnull
    public OutputStream newOutputStream(@Nonnull Path filePath) throws IOException {
        return Files.newOutputStream(filePath, new OpenOption[0]);
    }

    @Override
    public void moveFileTree(@Nonnull Path sourcePath, @Nonnull Path targetPath) throws IOException {
        this.copyFileTree(sourcePath, targetPath);
        this.deleteFileTree(sourcePath, true);
    }

    @Override
    public boolean setFileExecutable(@Nonnull Path path, @Nonnull Platform platform) throws IOException {
        boolean touched = !platform.isWindowsOs() && Files.exists(path, new LinkOption[0]) && !Files.isExecutable(path) ? this.setFileExecutable(path, Files.getPosixFilePermissions(path, new LinkOption[0]), platform) : false;
        return touched;
    }

    @Override
    @Nonnull
    public Path setPosixFilePermissions(@Nonnull Path path, @Nonnull Set<PosixFilePermission> permissions) throws IOException {
        return Files.setPosixFilePermissions(path, permissions);
    }

    private boolean setFileExecutable(@Nonnull Path path, @Nonnull Set<PosixFilePermission> originalPermissions, @Nonnull Platform platform) throws IOException {
        boolean touched;
        if (!platform.isWindowsOs() && Files.exists(path, new LinkOption[0]) && !Files.isExecutable(path)) {
            EnumSet<PosixFilePermission> newPermissions = EnumSet.copyOf(originalPermissions);
            newPermissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path, newPermissions);
            touched = true;
        } else {
            touched = false;
        }
        return touched;
    }

    public static class FileCopyVisitor
    extends SimpleFileVisitor<Path> {
        private final Path rootPath;
        private final Path targetPath;

        FileCopyVisitor(Path rootPath, Path targetPath) {
            this.rootPath = rootPath;
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes basicFileAttributes) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.rootPath.relativize(file)).normalize(), StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.copy(file, this.targetPath.resolve(this.rootPath.relativize(file)).normalize(), StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
            return FileVisitResult.CONTINUE;
        }
    }

    public static class FileDeleteVisitor
    extends SimpleFileVisitor<Path> {
        private final Path rootPath;
        private final boolean deleteRootEnabled;

        FileDeleteVisitor(Path rootPath, boolean deleteRootEnabled) {
            this.rootPath = rootPath;
            this.deleteRootEnabled = deleteRootEnabled;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path directory, IOException e) throws IOException {
            if (e == null) {
                if (this.deleteRootEnabled || !directory.equals(this.rootPath)) {
                    Files.delete(directory);
                }
                return FileVisitResult.CONTINUE;
            }
            throw e;
        }
    }
}

