/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import java.nio.file.Path;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.siouan.frontendgradleplugin.domain.exception.ExecutableNotFoundException;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.infrastructure.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.Beans;
import org.siouan.frontendgradleplugin.infrastructure.gradle.adapter.GradleScriptRunnerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.gradle.adapter.ScriptProperties;

public abstract class AbstractRunCommandTask
extends DefaultTask {
    final Property<File> packageJsonDirectory = this.getProject().getObjects().property(File.class);
    final DirectoryProperty nodeInstallDirectory = this.getProject().getObjects().directoryProperty();
    final Property<Boolean> yarnEnabled = this.getProject().getObjects().property(Boolean.class);
    final DirectoryProperty yarnInstallDirectory = this.getProject().getObjects().directoryProperty();
    final Property<String> script = this.getProject().getObjects().property(String.class);

    AbstractRunCommandTask() {
    }

    @Input
    @Optional
    public Property<File> getPackageJsonDirectory() {
        return this.packageJsonDirectory;
    }

    @Internal
    public DirectoryProperty getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    @Internal
    public DirectoryProperty getYarnInstallDirectory() {
        return this.yarnInstallDirectory;
    }

    @Internal
    protected abstract String getExecutableType();

    @TaskAction
    public void execute() throws ExecutableNotFoundException, BeanRegistryException {
        if (this.script.isPresent()) {
            Beans.getBean(GradleScriptRunnerAdapter.class).execute(new ScriptProperties(this.getProject(), (Path)this.packageJsonDirectory.map(File::toPath).get(), this.getExecutableType(), (Path)this.nodeInstallDirectory.getAsFile().map(File::toPath).getOrNull(), (Path)this.yarnInstallDirectory.getAsFile().map(File::toPath).getOrNull(), (String)this.script.get(), Beans.getBean(Platform.class)));
        }
    }
}

