/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.siouan.frontendgradleplugin.domain.exception.ArchiverException;
import org.siouan.frontendgradleplugin.domain.exception.DistributionValidatorException;
import org.siouan.frontendgradleplugin.domain.exception.InvalidDistributionUrlException;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedDistributionArchiveException;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedDistributionIdException;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedPlatformException;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.InstallSettings;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.domain.usecase.AbstractInstallDistribution;
import org.siouan.frontendgradleplugin.infrastructure.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.Beans;

public abstract class AbstractDistributionInstallTask
extends DefaultTask {
    private final Property<String> proxyHost = this.getProject().getObjects().property(String.class);
    private final Property<Integer> proxyPort = this.getProject().getObjects().property(Integer.class);
    private final Property<String> proxyUsername = this.getProject().getObjects().property(String.class);
    private final Property<String> proxyPassword = this.getProject().getObjects().property(String.class);

    @Internal
    public Property<String> getProxyHost() {
        return this.proxyHost;
    }

    @Internal
    public Property<Integer> getProxyPort() {
        return this.proxyPort;
    }

    @Internal
    public Property<String> getProxyUsername() {
        return this.proxyUsername;
    }

    @Internal
    public Property<String> getProxyPassword() {
        return this.proxyPassword;
    }

    @TaskAction
    public void execute() throws BeanRegistryException, ArchiverException, UnsupportedDistributionArchiveException, UnsupportedPlatformException, UnsupportedDistributionIdException, InvalidDistributionUrlException, DistributionValidatorException, IOException {
        Credentials proxyServerCredentials;
        Proxy proxy;
        Credentials distributionServerCredentials = this.getDistributionServerCredentials();
        if (this.proxyHost.isPresent()) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress((String)this.proxyHost.get(), (int)((Integer)this.proxyPort.get())));
            proxyServerCredentials = this.proxyUsername.isPresent() ? new Credentials((String)this.proxyUsername.get(), (String)this.proxyPassword.get()) : null;
        } else {
            proxy = Proxy.NO_PROXY;
            proxyServerCredentials = null;
        }
        Beans.getBean(this.getInstallDistributionClass()).execute(this.getInstallSettings(Beans.getBean(Platform.class), distributionServerCredentials, new ProxySettings(proxy, proxyServerCredentials)));
    }

    @Internal
    @Nullable
    protected abstract Credentials getDistributionServerCredentials();

    @Internal
    @Nonnull
    protected abstract Class<? extends AbstractInstallDistribution> getInstallDistributionClass();

    @Nonnull
    protected abstract InstallSettings getInstallSettings(@Nonnull Platform var1, @Nullable Credentials var2, @Nonnull ProxySettings var3);
}

