/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.model.Platform;

public interface FileManager {
    public long copy(@Nonnull InputStream var1, @Nonnull Path var2) throws IOException;

    public void copyFileTree(@Nonnull Path var1, @Nonnull Path var2) throws IOException;

    @Nonnull
    public Path createDirectories(@Nonnull Path var1) throws IOException;

    @Nonnull
    public Path createDirectory(@Nonnull Path var1) throws IOException;

    @Nonnull
    public Path createSymbolicLink(@Nonnull Path var1, @Nonnull Path var2) throws IOException;

    public void delete(@Nonnull Path var1) throws IOException;

    public boolean deleteIfExists(@Nonnull Path var1) throws IOException;

    public void deleteFileTree(@Nonnull Path var1, boolean var2) throws IOException;

    public boolean exists(@Nonnull Path var1);

    public boolean isDirectory(@Nonnull Path var1);

    public boolean isSameFile(@Nonnull Path var1, @Nonnull Path var2) throws IOException;

    @Nonnull
    public Stream<Path> list(@Nonnull Path var1) throws IOException;

    @Nonnull
    public Path move(@Nonnull Path var1, @Nonnull Path var2, CopyOption ... var3) throws IOException;

    @Nonnull
    public BufferedReader newBufferedReader(@Nonnull Path var1) throws IOException;

    @Nonnull
    public InputStream newInputStream(@Nonnull Path var1) throws IOException;

    @Nonnull
    public OutputStream newOutputStream(@Nonnull Path var1) throws IOException;

    public void moveFileTree(@Nonnull Path var1, @Nonnull Path var2) throws IOException;

    public boolean setFileExecutable(@Nonnull Path var1, @Nonnull Platform var2) throws IOException;

    @Nonnull
    public Path setPosixFilePermissions(@Nonnull Path var1, @Nonnull Set<PosixFilePermission> var2) throws IOException;
}

