/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.slf4jmock.mockito;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.internal.configuration.InjectingAnnotationEngine;
import org.mockito.internal.util.reflection.InstanceField;
import org.simplify4u.slf4jmock.LoggerMock;
import org.simplify4u.slf4jmock.MDCMock;
import org.simplify4u.slf4jmock.SimpleLogger;
import org.simplify4u.slf4jmock.internal.ProxyMock;
import org.simplify4u.slf4jmock.mockito.MockRuntimeException;
import org.slf4j.Logger;
import org.slf4j.spi.MDCAdapter;

public final class LoggerAnnotationEngine
extends InjectingAnnotationEngine {
    private static final Logger FAKE_LOGGER = new SimpleLogger("");

    public AutoCloseable process(Class<?> clazz, Object testInstance) {
        InstanceField spyToSet = LoggerAnnotationEngine.prepareSpyLogger(testInstance);
        AutoCloseable processResult = super.process(clazz, testInstance);
        Optional<MDCAdapter> mdcMoc = LoggerAnnotationEngine.findMDCMock(testInstance);
        mdcMoc.ifPresent(MDCMock::setMock);
        Map<String, Logger> loggersMocks = LoggerAnnotationEngine.findLoggersMocks(testInstance, spyToSet);
        loggersMocks.forEach(LoggerMock::setMock);
        return () -> {
            processResult.close();
            MDCMock.clearMock();
            loggersMocks.keySet().forEach(LoggerMock::clearMock);
        };
    }

    private static List<InstanceField> allDeclaredFieldsOf(Object testInstance) {
        ArrayList<InstanceField> result = new ArrayList<InstanceField>();
        for (Class<?> clazz = testInstance.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                result.add(new InstanceField(field, testInstance));
            }
        }
        return result;
    }

    private static InstanceField prepareSpyLogger(Object testInstance) {
        List spyMocks = LoggerAnnotationEngine.allDeclaredFieldsOf(testInstance).stream().filter(field -> field.jdkField().getType() == Logger.class).filter(field -> field.isAnnotatedBy(Spy.class)).collect(Collectors.toList());
        List<InstanceField> nullSpy = spyMocks.stream().filter(field -> field.read() == null).collect(Collectors.toList());
        nullSpy.forEach(field -> field.set((Object)FAKE_LOGGER));
        return nullSpy.stream().findFirst().orElse(null);
    }

    private static Optional<MDCAdapter> findMDCMock(Object testInstance) {
        List mdcFields = LoggerAnnotationEngine.allDeclaredFieldsOf(testInstance).stream().filter(instanceField -> instanceField.jdkField().getType() == MDCAdapter.class).filter(instanceField -> instanceField.isAnnotatedBy(Mock.class)).collect(Collectors.toList());
        if (mdcFields.size() > 1) {
            throw new MockRuntimeException("Class:  " + testInstance.getClass() + "\ncontains more then one mock for MDCAdapter\n\n" + mdcFields.stream().map(InstanceField::name).map(n -> "    @Mock\n    MDCAdapter " + n + ";").collect(Collectors.joining("\n\n")) + "\n\nonly one or zero is allowed per unit test");
        }
        return mdcFields.stream().findFirst().map(InstanceField::read).map(MDCAdapter.class::cast);
    }

    private static List<InstanceField> findClassUnderTest(Object testInstance) {
        return LoggerAnnotationEngine.allDeclaredFieldsOf(testInstance).stream().filter(instanceField -> instanceField.isAnnotatedBy(InjectMocks.class)).collect(Collectors.toList());
    }

    private static Map<String, Logger> findLoggersMocks(Object testInstance, InstanceField spyToSet) {
        Logger newLogger;
        Map<String, Logger> loggerMocks = LoggerAnnotationEngine.allDeclaredFieldsOf(testInstance).stream().filter(field -> field.jdkField().getType() == Logger.class).filter(field -> field.isAnnotatedBy(Mock.class) || field.isAnnotatedBy(Spy.class)).collect(Collectors.toMap(LoggerAnnotationEngine::getLoggerName, LoggerAnnotationEngine::getLoggerFromFiled, LoggerAnnotationEngine::mockLoggerMerge));
        if (!loggerMocks.containsKey("")) {
            return loggerMocks;
        }
        List<InstanceField> classesUnderTest = LoggerAnnotationEngine.findClassUnderTest(testInstance);
        if (classesUnderTest.isEmpty()) {
            throw new MockRuntimeException("We have unnamed Logger for @Mock or @Spy we need at lease one class under test with @InjectMock in order to discover Logger name");
        }
        List loggersUnderTest = classesUnderTest.stream().map(InstanceField::read).map(LoggerAnnotationEngine::allDeclaredFieldsOf).flatMap(Collection::stream).filter(field -> field.jdkField().getType() == Logger.class).collect(Collectors.toList());
        if (loggersUnderTest.isEmpty()) {
            throw new MockRuntimeException("Classes under test doesn't have defined Logger");
        }
        if (loggersUnderTest.size() > 1) {
            throw new MockRuntimeException("Classes under test has define to many Loggers\nWe need one Logger defined in all class under test for unnamed @Mock or @Spy");
        }
        InstanceField instanceField = (InstanceField)loggersUnderTest.get(0);
        String loggerName = ((ProxyMock)instanceField.read()).getMockName();
        Logger oldLogger = loggerMocks.remove("");
        if (Mockito.mockingDetails((Object)oldLogger).isSpy()) {
            newLogger = (Logger)Mockito.spy((Object)new SimpleLogger(loggerName));
            Optional.ofNullable(spyToSet).ifPresent(field -> field.set((Object)newLogger));
        } else {
            newLogger = oldLogger;
        }
        loggerMocks.put(loggerName, newLogger);
        return loggerMocks;
    }

    private static Logger mockLoggerMerge(Logger l1, Logger l2) {
        throw new MockRuntimeException("Logger Mock must have unique name,  but we have: " + l1 + " and " + l2 + "\nplease define like:\n   @Mock(name=\"logger.name\")");
    }

    private static String getLoggerName(InstanceField field) {
        String name = Optional.ofNullable(field.annotation(Mock.class)).map(Mock::name).orElse(null);
        if (name == null) {
            Optional<Logger> logger = Optional.ofNullable(field.read()).map(Logger.class::cast);
            name = logger.map(Logger::getName).orElse(null);
            logger.ifPresent(xva$0 -> Mockito.clearInvocations((Object[])new Logger[]{xva$0}));
        }
        return name;
    }

    private static Logger getLoggerFromFiled(InstanceField field) {
        return (Logger)field.read();
    }
}

