/*
 * Decompiled with CFR 0.152.
 */
package org.simplify4u.slf4jmock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.simplify4u.slf4jmock.MockInvocationHandler;
import org.simplify4u.slf4jmock.SimpleLogger;
import org.simplify4u.slf4jmock.internal.ProxyMock;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public final class LoggerMock {
    private static final ILoggerFactory loggerFactory = LoggerMock::getLoggerProxyByName;
    private static final Map<String, Logger> loggers = new HashMap<String, Logger>();

    private LoggerMock() {
    }

    private static Logger createNewLoggerProxy(String name) {
        return (Logger)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Logger.class, ProxyMock.class}, (InvocationHandler)new MockInvocationHandler(name, () -> (SimpleLogger)Mockito.mock(SimpleLogger.class, (MockSettings)Mockito.withSettings().spiedInstance((Object)new SimpleLogger(name)).defaultAnswer(Mockito.CALLS_REAL_METHODS).stubOnly())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Logger getLoggerProxyByName(String name) {
        Map<String, Logger> map = loggers;
        synchronized (map) {
            return loggers.computeIfAbsent(name, LoggerMock::createNewLoggerProxy);
        }
    }

    private static ProxyMock getProxyByName(String name) {
        return (ProxyMock)LoggerMock.getLoggerProxyByName(name);
    }

    public static ILoggerFactory getLoggerFactory() {
        return loggerFactory;
    }

    public static void setMock(Class<?> klass, Logger mock) {
        LoggerMock.setMock(klass.getName(), mock);
    }

    public static void setMock(String name, Logger mock) {
        LoggerMock.getProxyByName(name).setMock(mock);
    }

    public static void clearMock(Class<?> klass) {
        LoggerMock.clearMock(klass.getName());
    }

    public static void clearMock(String name) {
        LoggerMock.getProxyByName(name).clearMock();
    }
}

