/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.utils.mail.smime;

import com.sun.mail.smtp.SMTPMessage;
import jakarta.activation.CommandMap;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.simplejavamail.utils.mail.smime.MimeUtil;
import org.simplejavamail.utils.mail.smime.SmimeException;
import org.simplejavamail.utils.mail.smime.SmimeKey;
import org.simplejavamail.utils.mail.smime.SmimeState;
import org.simplejavamail.utils.mail.smime.UpdatableMimeBodyPart;

public final class SmimeUtil {
    private SmimeUtil() {
    }

    private static void updateMailcapCommandMap() {
        MailcapCommandMap map = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        map.addMailcap("application/pkcs7-signature;;x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        map.addMailcap("application/pkcs7-mime;;x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        map.addMailcap("application/x-pkcs7-signature;;x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        map.addMailcap("application/x-pkcs7-mime;;x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        map.addMailcap("multipart/signed;;x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        CommandMap.setDefaultCommandMap((CommandMap)map);
    }

    public static MimeMessage encrypt(Session session, MimeMessage mimeMessage, X509Certificate certificate) {
        try {
            MimeMessage encryptedMimeMessage = new MimeMessage(session);
            SmimeUtil.copyHeaders(mimeMessage, encryptedMimeMessage);
            SMIMEEnvelopedGenerator generator = SmimeUtil.prepareGenerator(certificate);
            OutputEncryptor encryptor = SmimeUtil.prepareEncryptor();
            MimeBodyPart encryptedMimeBodyPart = generator.generate(mimeMessage, encryptor);
            SmimeUtil.copyContent(encryptedMimeBodyPart, encryptedMimeMessage);
            SmimeUtil.copyHeaders(encryptedMimeBodyPart, encryptedMimeMessage);
            encryptedMimeMessage.saveChanges();
            return encryptedMimeMessage;
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    public static MimeBodyPart encrypt(MimeBodyPart mimeBodyPart, X509Certificate certificate) {
        try {
            SMIMEEnvelopedGenerator generator = SmimeUtil.prepareGenerator(certificate);
            OutputEncryptor encryptor = SmimeUtil.prepareEncryptor();
            return generator.generate(mimeBodyPart, encryptor);
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    private static void copyHeaders(MimeBodyPart fromBodyPart, MimeMessage toMessage) throws MessagingException {
        Enumeration headers = fromBodyPart.getAllHeaders();
        SmimeUtil.copyHeaders(headers, toMessage);
    }

    private static void copyHeaders(MimeMessage fromMessage, MimeMessage toMessage) throws MessagingException {
        Enumeration headers = fromMessage.getAllHeaders();
        SmimeUtil.copyHeaders(headers, toMessage);
    }

    private static void copyHeaders(Enumeration<Header> headers, MimeMessage toMessage) throws MessagingException {
        while (headers.hasMoreElements()) {
            Header header = headers.nextElement();
            toMessage.setHeader(header.getName(), header.getValue());
        }
    }

    private static SMIMEEnvelopedGenerator prepareGenerator(X509Certificate certificate) throws CertificateEncodingException {
        JceKeyTransRecipientInfoGenerator infoGenerator = new JceKeyTransRecipientInfoGenerator(certificate);
        infoGenerator.setProvider("BC");
        SMIMEEnvelopedGenerator generator = new SMIMEEnvelopedGenerator();
        generator.addRecipientInfoGenerator((RecipientInfoGenerator)infoGenerator);
        return generator;
    }

    private static OutputEncryptor prepareEncryptor() throws CMSException {
        return new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider("BC").build();
    }

    public static MimeMessage decrypt(Session session, MimeMessage mimeMessage, SmimeKey smimeKey) {
        try {
            byte[] content = SmimeUtil.decryptContent(new SMIMEEnveloped(mimeMessage), smimeKey);
            MimeBodyPart mimeBodyPart = SMIMEUtil.toMimeBodyPart((byte[])content);
            MimeMessage decryptedMessage = new MimeMessage(session);
            SmimeUtil.copyHeaderLines(mimeMessage, decryptedMessage);
            SmimeUtil.copyContent(mimeBodyPart, decryptedMessage);
            decryptedMessage.setHeader("Content-Type", mimeBodyPart.getContentType());
            return decryptedMessage;
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    public static MimeBodyPart decrypt(MimeBodyPart mimeBodyPart, SmimeKey smimeKey) {
        try {
            return SMIMEUtil.toMimeBodyPart((byte[])SmimeUtil.decryptContent(new SMIMEEnveloped(mimeBodyPart), smimeKey));
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    public static MimeBodyPart decrypt(MimeMultipart mimeMultipart, SmimeKey smimeKey) {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Multipart)mimeMultipart);
            mimeBodyPart.setHeader("Content-Type", mimeMultipart.getContentType());
            return SmimeUtil.decrypt(mimeBodyPart, smimeKey);
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    private static byte[] decryptContent(SMIMEEnveloped smimeEnveloped, SmimeKey smimeKey) throws MessagingException, CMSException {
        X509Certificate certificate = smimeKey.getCertificate();
        PrivateKey privateKey = smimeKey.getPrivateKey();
        RecipientInformationStore recipients = smimeEnveloped.getRecipientInfos();
        RecipientInformation recipient = recipients.get((RecipientId)new JceKeyTransRecipientId(certificate));
        if (null == recipient) {
            throw new MessagingException("no recipient");
        }
        JceKeyTransEnvelopedRecipient transportRecipient = new JceKeyTransEnvelopedRecipient(privateKey);
        transportRecipient.setProvider("BC");
        return recipient.getContent((Recipient)transportRecipient);
    }

    private static void copyHeaderLines(MimeMessage fromMessage, MimeMessage toMessage) throws MessagingException {
        Enumeration headerLines = fromMessage.getAllHeaderLines();
        while (headerLines.hasMoreElements()) {
            String nextElement = (String)headerLines.nextElement();
            toMessage.addHeaderLine(nextElement);
        }
    }

    private static void copyContent(MimeBodyPart fromBodyPart, MimeMessage toMessage) throws MessagingException, IOException {
        toMessage.setContent(fromBodyPart.getContent(), fromBodyPart.getContentType());
    }

    public static MimeBodyPart sign(MimeBodyPart mimeBodyPart, SmimeKey smimeKey) {
        try {
            SMIMESignedGenerator generator = SmimeUtil.getGenerator(smimeKey);
            MimeMultipart signedMimeMultipart = generator.generate(MimeUtil.canonicalize(mimeBodyPart));
            MimeBodyPart signedMimeBodyPart = new MimeBodyPart();
            signedMimeBodyPart.setContent((Multipart)signedMimeMultipart);
            return signedMimeBodyPart;
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    private static SMIMESignedGenerator getGenerator(SmimeKey smimeKey) throws CertificateEncodingException, OperatorCreationException {
        SMIMESignedGenerator generator = new SMIMESignedGenerator();
        generator.addCertificates((Store)SmimeUtil.getCertificateStore(smimeKey));
        generator.addSignerInfoGenerator(SmimeUtil.getInfoGenerator(smimeKey));
        return generator;
    }

    private static SignerInfoGenerator getInfoGenerator(SmimeKey smimeKey) throws OperatorCreationException, CertificateEncodingException {
        JcaSimpleSignerInfoGeneratorBuilder builder = new JcaSimpleSignerInfoGeneratorBuilder();
        builder.setSignedAttributeGenerator(new AttributeTable(SmimeUtil.getSignedAttributes(smimeKey)));
        builder.setProvider("BC");
        PrivateKey privateKey = smimeKey.getPrivateKey();
        X509Certificate certificate = smimeKey.getCertificate();
        return builder.build("SHA256withRSA", privateKey, certificate);
    }

    private static ASN1EncodableVector getSignedAttributes(SmimeKey smimeKey) {
        ASN1EncodableVector signedAttributes = new ASN1EncodableVector();
        IssuerAndSerialNumber issuerAndSerialNumber = SmimeUtil.getIssuerAndSerialNumber(smimeKey);
        signedAttributes.add((ASN1Encodable)new SMIMEEncryptionKeyPreferenceAttribute(issuerAndSerialNumber));
        signedAttributes.add((ASN1Encodable)new SMIMECapabilitiesAttribute(SmimeUtil.getCapabilityVector()));
        return signedAttributes;
    }

    private static SMIMECapabilityVector getCapabilityVector() {
        SMIMECapabilityVector capabilityVector = new SMIMECapabilityVector();
        capabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
        capabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
        capabilityVector.addCapability(SMIMECapability.dES_CBC);
        return capabilityVector;
    }

    private static IssuerAndSerialNumber getIssuerAndSerialNumber(SmimeKey smimeKey) {
        X509Certificate certificate = smimeKey.getCertificate();
        BigInteger serialNumber = certificate.getSerialNumber();
        X500Name issuerName = new X500Name(certificate.getIssuerDN().getName());
        return new IssuerAndSerialNumber(issuerName, serialNumber);
    }

    private static JcaCertStore getCertificateStore(SmimeKey smimeKey) throws CertificateEncodingException {
        List<X509Certificate> certificateList;
        X509Certificate[] certificateChain = smimeKey.getCertificateChain();
        X509Certificate certificate = smimeKey.getCertificate();
        if (certificateChain != null && certificateChain.length > 0) {
            certificateList = Arrays.asList(certificateChain);
        } else {
            certificateList = new ArrayList<X509Certificate>();
            certificateList.add(certificate);
        }
        return new JcaCertStore(certificateList);
    }

    public static <T extends MimeMessage> T sign(Session session, T mimeMessage, SmimeKey smimeKey) {
        return (T)(mimeMessage instanceof SMTPMessage ? SmimeUtil.sign(mimeMessage, new SMTPMessage(session), smimeKey) : SmimeUtil.sign(mimeMessage, new MimeMessage(session), smimeKey));
    }

    private static <T extends MimeMessage> T sign(T mimeMessage, T signedMessage, SmimeKey smimeKey) {
        try {
            SmimeUtil.copyHeaderLines(mimeMessage, signedMessage);
            SmimeUtil.copyContent(SmimeUtil.sign(SmimeUtil.extractMimeBodyPart(mimeMessage), smimeKey), signedMessage);
            return signedMessage;
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    private static MimeBodyPart extractMimeBodyPart(MimeMessage mimeMessage) throws IOException, MessagingException {
        Object content = mimeMessage.getContent();
        UpdatableMimeBodyPart updateableMimeBodyPart = new UpdatableMimeBodyPart();
        if (content instanceof Multipart) {
            updateableMimeBodyPart.setContent((Multipart)content);
        } else {
            updateableMimeBodyPart.setContent(content, mimeMessage.getDataHandler().getContentType());
        }
        updateableMimeBodyPart.updateHeaders();
        return updateableMimeBodyPart;
    }

    public static boolean checkSignature(MimeMultipart mimeMultipart) {
        try {
            return SmimeUtil.checkSignature(new SMIMESigned(mimeMultipart));
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    public static boolean checkSignature(MimePart mimePart) {
        try {
            if (mimePart.isMimeType("multipart/signed")) {
                return SmimeUtil.checkSignature(new SMIMESigned((MimeMultipart)mimePart.getContent()));
            }
            if (mimePart.isMimeType("application/pkcs7-mime") || mimePart.isMimeType("application/x-pkcs7-mime")) {
                return SmimeUtil.checkSignature(new SMIMESigned((Part)mimePart));
            }
            throw new SmimeException("Message not signed");
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    private static boolean checkSignature(SMIMESigned smimeSigned) {
        try {
            boolean returnValue = true;
            Store certificates = smimeSigned.getCertificates();
            Iterator signerInformations = smimeSigned.getSignerInfos().getSigners().iterator();
            while (returnValue && signerInformations.hasNext()) {
                X509Certificate certificate;
                SignerInformationVerifier verifier;
                SignerInformation signerInformation = (SignerInformation)signerInformations.next();
                if (signerInformation.verify(verifier = SmimeUtil.getVerifier(certificate = SmimeUtil.getCertificate(certificates, signerInformation.getSID())))) continue;
                returnValue = false;
            }
            return returnValue;
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    public static String getSignedByAddress(MimeMultipart mimeMultipart) {
        try {
            return SmimeUtil.getSignedByAddress(new SMIMESigned(mimeMultipart));
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    public static String getSignedByAddress(MimePart mimePart) {
        try {
            if (mimePart.isMimeType("multipart/signed")) {
                return SmimeUtil.getSignedByAddress(new SMIMESigned((MimeMultipart)mimePart.getContent()));
            }
            if (mimePart.isMimeType("application/pkcs7-mime") || mimePart.isMimeType("application/x-pkcs7-mime")) {
                return SmimeUtil.getSignedByAddress(new SMIMESigned((Part)mimePart));
            }
            throw new SmimeException("Message not signed");
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    private static String getSignedByAddress(SMIMESigned smimeSigned) {
        try {
            Store certificates = smimeSigned.getCertificates();
            SignerInformation signerInformation = (SignerInformation)smimeSigned.getSignerInfos().getSigners().iterator().next();
            X509Certificate certificate = SmimeUtil.getCertificate(certificates, signerInformation.getSID());
            SignerInformationVerifier verifier = SmimeUtil.getVerifier(certificate);
            X500Name x500name = verifier.getAssociatedCertificate().getSubject();
            RDN cn = x500name.getRDNs(BCStyle.CN)[0];
            return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    private static X509Certificate getCertificate(Store certificates, SignerId signerId) throws CertificateException {
        X509CertificateHolder certificateHolder = (X509CertificateHolder)certificates.getMatches((Selector)signerId).iterator().next();
        JcaX509CertificateConverter certificateConverter = new JcaX509CertificateConverter();
        certificateConverter.setProvider("BC");
        return certificateConverter.getCertificate(certificateHolder);
    }

    private static SignerInformationVerifier getVerifier(X509Certificate certificate) throws OperatorCreationException {
        JcaSimpleSignerInfoVerifierBuilder builder = new JcaSimpleSignerInfoVerifierBuilder();
        builder.setProvider("BC");
        return builder.build(certificate);
    }

    public static MimeBodyPart getSignedContent(MimeMultipart mimeMultipart) {
        try {
            return new SMIMESigned(mimeMultipart).getContent();
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    public static MimeBodyPart getSignedContent(MimePart mimePart) {
        try {
            if (mimePart.isMimeType("multipart/signed")) {
                return new SMIMESigned((MimeMultipart)mimePart.getContent()).getContent();
            }
            if (mimePart.isMimeType("application/pkcs7-mime") || mimePart.isMimeType("application/x-pkcs7-mime")) {
                return new SMIMESigned((Part)mimePart).getContent();
            }
            throw new SmimeException("Message not signed");
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    public static SmimeState getStatus(MimeMultipart mimeMultipart) {
        try {
            return SmimeUtil.getStatus(new ContentType(mimeMultipart.getContentType()));
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    public static SmimeState getStatus(MimePart mimePart) {
        try {
            return SmimeUtil.getStatus(new ContentType(mimePart.getContentType()));
        }
        catch (Exception e) {
            throw SmimeUtil.handledException(e);
        }
    }

    private static SmimeState getStatus(ContentType contentType) {
        if (SmimeUtil.isSmimeSignatureContentType(contentType)) {
            return SmimeState.SIGNED;
        }
        if (SmimeUtil.isSignatureSmimeType(contentType)) {
            return SmimeState.SIGNED_ENVELOPED;
        }
        if (SmimeUtil.isSmimeEncryptionContenttype(contentType)) {
            return SmimeState.ENCRYPTED;
        }
        return SmimeState.NEITHER;
    }

    private static boolean isSmimeEncryptionContenttype(ContentType contentType) {
        String baseContentType = contentType.getBaseType();
        return baseContentType.equalsIgnoreCase("application/pkcs7-mime") || baseContentType.equalsIgnoreCase("application/x-pkcs7-mime");
    }

    private static boolean isSmimeSignatureContentType(ContentType contentType) {
        String baseContentType = contentType.getBaseType();
        return baseContentType.equalsIgnoreCase("multipart/signed") && SmimeUtil.isSmimeSignatureProtocoll(contentType.getParameter("protocol"));
    }

    private static boolean isSignatureSmimeType(ContentType contentType) {
        String baseContentType = contentType.getBaseType();
        return baseContentType.equalsIgnoreCase("application/x-pkcs7-mime") && "signed-data".equals(contentType.getParameter("smime-type"));
    }

    private static boolean isSmimeSignatureProtocoll(String protocol) {
        return protocol.equalsIgnoreCase("application/pkcs7-signature") || protocol.equalsIgnoreCase("application/x-pkcs7-signature");
    }

    private static SmimeException handledException(Exception e) {
        if (e instanceof SmimeException) {
            return (SmimeException)e;
        }
        return new SmimeException(e.getMessage(), e);
    }

    static {
        if (null == Security.getProvider("BC")) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            SmimeUtil.updateMailcapCommandMap();
        }
    }
}

