/*
 * Copyright © 2021 Benny Bottema (benny@bennybottema.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.simplejavamail.utils.mail.smime;

import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;

/**
 * The {@code SmimeState} of a {@link MimePart} or {@link MimeMultipart} is
 * derived from the corresponding content type and can be obtained with
 * {@link SmimeUtil#checkSignature(MimePart) checkSignature()};
 * 
 * @author Torsten Krause (tk at markenwerk dot net)
 * @since 1.0.0
 */
public enum SmimeState {

	/**
	 * Indicates that the {@link MimePart} or {@link MimeMultipart} is S/MIME
	 * encrypted.
	 */
	ENCRYPTED,
	
	/**
	 * Indicates that the {@link MimePart} or {@link MimeMultipart} is S/MIME
	 * signed.
	 */
	SIGNED,
	
	/**
	 * Indicates that the {@link MimePart} or {@link MimeMultipart} is S/MIME
	 * signed using the older envelope style.
	 */
	SIGNED_ENVELOPED,

	/**
	 * Indicates that the {@link MimePart} or {@link MimeMultipart} is neither
	 * S/MIME encrypted nor S/MIME signed.
	 */
	NEITHER
	
}
