/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.utils.mail.dkim;

public enum Canonicalization {
    SIMPLE{

        @Override
        public String canonicalizeHeader(String name, String value) {
            return name + ": " + value;
        }

        @Override
        public String canonicalizeBody(String body) {
            if (body == null) {
                return "\r\n";
            }
            if (!body.endsWith("\r\n")) {
                return body + "\r\n";
            }
            while (body.endsWith("\r\n\r\n")) {
                body = body.substring(0, body.length() - 2);
            }
            return body;
        }
    }
    ,
    RELAXED{

        @Override
        public String canonicalizeHeader(String name, String value) {
            return name.trim().toLowerCase() + ":" + value.replaceAll("\\s+", " ").trim();
        }

        @Override
        public String canonicalizeBody(String body) {
            if (body == null) {
                return "";
            }
            if (!body.endsWith("\r\n")) {
                body = body + "\r\n";
            }
            body = body.replaceAll("[ \\t]+\r\n", "\r\n");
            body = body.replaceAll("[ \\t]+", " ");
            while (body.endsWith("\r\n\r\n")) {
                body = body.substring(0, body.length() - 2);
            }
            if ("\r\n".equals(body)) {
                body = "";
            }
            return body;
        }
    };


    public final String getType() {
        return this.name().toLowerCase();
    }

    public abstract String canonicalizeHeader(String var1, String var2);

    public abstract String canonicalizeBody(String var1);
}

