/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.smimesupport.model;

import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.OriginalSmimeDetails;
import org.simplejavamail.internal.smimesupport.SmimeRecognitionUtil;

public class OriginalSmimeDetailsImpl
implements OriginalSmimeDetails {
    private static final long serialVersionUID = 1234567L;
    @Nullable
    private OriginalSmimeDetails.SmimeMode smimeMode;
    @Nullable
    private String smimeMime;
    @Nullable
    private String smimeType;
    @Nullable
    private String smimeName;
    @Nullable
    private String smimeProtocol;
    @Nullable
    private String smimeMicalg;
    @Nullable
    private String smimeSignedBy;
    @Nullable
    private Boolean smimeSignatureValid;

    @ConstructorProperties(value={"smimeMime", "smimeType", "smimeName", "smimeProtocol", "smimeMicalg", "smimeSignedBy", "smimeSignatureValid"})
    private OriginalSmimeDetailsImpl(@Nullable OriginalSmimeDetails.SmimeMode smimeMode, @Nullable String smimeMime, @Nullable String smimeType, @Nullable String smimeName, @Nullable String smimeProtocol, @Nullable String smimeMicalg, @Nullable String smimeSignedBy, @Nullable Boolean smimeSignatureValid) {
        this.smimeMime = smimeMime;
        this.smimeType = smimeType;
        this.smimeName = smimeName;
        this.smimeProtocol = smimeProtocol;
        this.smimeMicalg = smimeMicalg;
        this.smimeSignedBy = smimeSignedBy;
        this.smimeSignatureValid = smimeSignatureValid;
        this.smimeMode = this.determineSmode(smimeMode);
    }

    public static OriginalSmimeDetailsBuilder builder() {
        return new OriginalSmimeDetailsBuilder();
    }

    public void completeWith(@NotNull OriginalSmimeDetails attachmentSmimeDetails) {
        this.smimeMime = Optional.ofNullable(this.smimeMime).orElse(attachmentSmimeDetails.getSmimeMime());
        this.smimeType = Optional.ofNullable(this.smimeType).orElse(attachmentSmimeDetails.getSmimeType());
        this.smimeName = Optional.ofNullable(this.smimeName).orElse(attachmentSmimeDetails.getSmimeName());
        this.smimeProtocol = Optional.ofNullable(this.smimeProtocol).orElse(attachmentSmimeDetails.getSmimeProtocol());
        this.smimeMicalg = Optional.ofNullable(this.smimeMicalg).orElse(attachmentSmimeDetails.getSmimeMicalg());
        this.smimeSignedBy = Optional.ofNullable(this.smimeSignedBy).orElse(attachmentSmimeDetails.getSmimeSignedBy());
        this.smimeSignatureValid = Optional.ofNullable(this.smimeSignatureValid).orElse(attachmentSmimeDetails.getSmimeSignatureValid());
        this.smimeMode = this.determineSmode(Optional.ofNullable(this.smimeMode).orElse(attachmentSmimeDetails.getSmimeMode()));
    }

    @Nullable
    private OriginalSmimeDetails.SmimeMode determineSmode(@Nullable OriginalSmimeDetails.SmimeMode smimeMode) {
        return smimeMode == OriginalSmimeDetails.SmimeMode.PLAIN ? SmimeRecognitionUtil.determineSmimeMode(this) : smimeMode;
    }

    public void completeWithSmimeSignedBy(@Nullable String smimeSignedBy) {
        this.smimeSignedBy = Optional.ofNullable(this.smimeSignedBy).orElse(smimeSignedBy);
    }

    public void completeWithSmimeSignatureValid(boolean signatureValid) {
        this.smimeSignatureValid = Boolean.TRUE.equals(this.smimeSignatureValid) || signatureValid;
    }

    public void completeWithSmimeMode(OriginalSmimeDetails.SmimeMode smimeMode) {
        this.smimeMode = this.determineSmode(smimeMode);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OriginalSmimeDetailsImpl that = (OriginalSmimeDetailsImpl)o;
        return Objects.equals(this.smimeMode, that.smimeMode) && Objects.equals(this.smimeMime, that.smimeMime) && Objects.equals(this.smimeType, that.smimeType) && Objects.equals(this.smimeName, that.smimeName) && Objects.equals(this.smimeProtocol, that.smimeProtocol) && Objects.equals(this.smimeMicalg, that.smimeMicalg) && Objects.equals(this.smimeSignedBy, that.smimeSignedBy) && Objects.equals(this.smimeSignatureValid, that.smimeSignatureValid);
    }

    public int hashCode() {
        return Objects.hash(this.smimeMode, this.smimeMime, this.smimeType, this.smimeName, this.smimeProtocol, this.smimeMicalg, this.smimeSignedBy, this.smimeSignatureValid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OriginalSmimeDetails{");
        return OriginalSmimeDetailsImpl.toString(sb, this.smimeMode, this.smimeMime, this.smimeType, this.smimeName, this.smimeProtocol, this.smimeMicalg, this.smimeSignedBy, this.smimeSignatureValid);
    }

    @Nullable
    public OriginalSmimeDetails.SmimeMode getSmimeMode() {
        return this.smimeMode;
    }

    @Nullable
    public String getSmimeMime() {
        return this.smimeMime;
    }

    @Nullable
    public String getSmimeType() {
        return this.smimeType;
    }

    @Nullable
    public String getSmimeName() {
        return this.smimeName;
    }

    @Nullable
    public String getSmimeProtocol() {
        return this.smimeProtocol;
    }

    @Nullable
    public String getSmimeMicalg() {
        return this.smimeMicalg;
    }

    @Nullable
    public String getSmimeSignedBy() {
        return this.smimeSignedBy;
    }

    @Nullable
    public Boolean getSmimeSignatureValid() {
        return this.smimeSignatureValid;
    }

    @NotNull
    private static String toString(StringBuilder sb, @Nullable OriginalSmimeDetails.SmimeMode smimeMode, @Nullable String smimeMime, @Nullable String smimeType, @Nullable String smimeName, @Nullable String smimeProtocol, @Nullable String smimeMicalg, @Nullable String smimeSignedBy, @Nullable Boolean smimeSignatureValid) {
        sb.append("smimeMode=").append(smimeMode);
        sb.append(", smimeMime='").append(smimeMime).append('\'');
        sb.append(", smimeType='").append(smimeType).append('\'');
        sb.append(", smimeName='").append(smimeName).append('\'');
        sb.append(", smimeProtocol='").append(smimeProtocol).append('\'');
        sb.append(", smimeMicalg='").append(smimeMicalg).append('\'');
        sb.append(", smimeSignedBy='").append(smimeSignedBy).append('\'');
        sb.append(", smimeSignatureValid=").append(smimeSignatureValid);
        sb.append('}');
        return sb.toString();
    }

    public static class OriginalSmimeDetailsBuilder {
        @Nullable
        private OriginalSmimeDetails.SmimeMode smimeMode = OriginalSmimeDetails.SmimeMode.PLAIN;
        @Nullable
        private String smimeMime;
        @Nullable
        private String smimeType;
        @Nullable
        private String smimeName;
        @Nullable
        private String smimeProtocol;
        @Nullable
        private String smimeMicalg;
        @Nullable
        private String smimeSignedBy;
        @Nullable
        private Boolean smimeSignatureValid;

        OriginalSmimeDetailsBuilder() {
        }

        public OriginalSmimeDetailsBuilder smimeMode(@Nullable OriginalSmimeDetails.SmimeMode smimeMode) {
            this.smimeMode = smimeMode;
            return this;
        }

        public OriginalSmimeDetailsBuilder smimeMime(@Nullable String smimeMime) {
            this.smimeMime = smimeMime;
            return this;
        }

        public OriginalSmimeDetailsBuilder smimeType(@Nullable String smimeType) {
            this.smimeType = smimeType;
            return this;
        }

        public OriginalSmimeDetailsBuilder smimeName(@Nullable String smimeName) {
            this.smimeName = smimeName;
            return this;
        }

        public OriginalSmimeDetailsBuilder smimeProtocol(@Nullable String smimeProtocol) {
            this.smimeProtocol = smimeProtocol;
            return this;
        }

        public OriginalSmimeDetailsBuilder smimeMicalg(@Nullable String smimeMicalg) {
            this.smimeMicalg = smimeMicalg;
            return this;
        }

        public OriginalSmimeDetailsBuilder smimeSignedBy(@Nullable String smimeSignedBy) {
            this.smimeSignedBy = smimeSignedBy;
            return this;
        }

        public OriginalSmimeDetailsBuilder smimeSignatureValid(@Nullable Boolean smimeSignatureValid) {
            this.smimeSignatureValid = smimeSignatureValid;
            return this;
        }

        public OriginalSmimeDetailsImpl build() {
            return new OriginalSmimeDetailsImpl(this.smimeMode, this.smimeMime, this.smimeType, this.smimeName, this.smimeProtocol, this.smimeMicalg, this.smimeSignedBy, this.smimeSignatureValid);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("OriginalSmimeDetailsBuilder{");
            return OriginalSmimeDetailsImpl.toString(sb, this.smimeMode, this.smimeMime, this.smimeType, this.smimeName, this.smimeProtocol, this.smimeMicalg, this.smimeSignedBy, this.smimeSignatureValid);
        }
    }
}

