/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.smimesupport;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.jetbrains.annotations.Nullable;

class CMSAlgorithmResolver {
    private static final Map<String, ASN1ObjectIdentifier> algorithmMap;

    CMSAlgorithmResolver() {
    }

    @Nullable
    static ASN1ObjectIdentifier resolve(String algorithmName) {
        return algorithmMap.get(algorithmName);
    }

    static {
        Field[] fields;
        algorithmMap = new HashMap<String, ASN1ObjectIdentifier>();
        for (Field field : fields = CMSAlgorithm.class.getDeclaredFields()) {
            if (!field.getType().equals(ASN1ObjectIdentifier.class)) continue;
            try {
                algorithmMap.put(field.getName(), (ASN1ObjectIdentifier)field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access CMSAlgorithm field: " + field.getName(), e);
            }
        }
    }
}

