/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.dkimsupport;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.utils.mail.dkim.DkimMessage;
import org.simplejavamail.utils.mail.dkim.DkimSigner;

public class DkimMessageIdFixingMimeMessage
extends DkimMessage {
    @Nullable
    private final String messageId;

    public DkimMessageIdFixingMimeMessage(MimeMessage message, DkimSigner signer, @Nullable String messageId) throws MessagingException {
        super(message, signer);
        this.messageId = messageId;
    }

    protected void updateMessageID() throws MessagingException {
        if (MiscUtil.valueNullOrEmpty((Object)this.messageId)) {
            super.updateMessageID();
        } else {
            this.setHeader("Message-ID", this.messageId);
        }
    }

    public String toString() {
        try {
            return String.format("DkimMessage<id:%s, subject:%s>", super.getMessageID(), super.getSubject());
        }
        catch (MessagingException e) {
            throw new IllegalStateException("should not reach here");
        }
    }
}

