/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.dkimsupport;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.internal.dkimsupport.DKIMSigningException;
import org.simplejavamail.internal.modules.DKIMModule;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.utils.mail.dkim.Canonicalization;
import org.simplejavamail.utils.mail.dkim.DkimMessage;
import org.simplejavamail.utils.mail.dkim.DkimSigner;
import org.simplejavamail.utils.mail.dkim.SigningAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DKIMSigner
implements DKIMModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(DKIMSigner.class);

    public MimeMessage signMessageWithDKIM(MimeMessage messageToSign, Email signingDetails) {
        LOGGER.debug("signing MimeMessage with DKIM...");
        try {
            String dkimSelector = (String)Preconditions.checkNonEmptyArgument((Object)signingDetails.getDkimSelector(), (String)"dkimSelector");
            DkimSigner dkimSigner = new DkimSigner(signingDetails.getDkimSigningDomain(), dkimSelector, (InputStream)new ByteArrayInputStream(signingDetails.getDkimPrivateKeyData()));
            dkimSigner.setIdentity(((Recipient)Preconditions.checkNonEmptyArgument((Object)signingDetails.getFromRecipient(), (String)"fromRecipient")).getAddress());
            dkimSigner.setHeaderCanonicalization(Canonicalization.RELAXED);
            dkimSigner.setBodyCanonicalization(Canonicalization.RELAXED);
            dkimSigner.setSigningAlgorithm(SigningAlgorithm.SHA256_WITH_RSA);
            dkimSigner.setLengthParam(true);
            dkimSigner.setZParam(false);
            return new DkimMessage(messageToSign, dkimSigner);
        }
        catch (MessagingException | IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new DKIMSigningException("Error signing MimeMessage with DKIM", (Exception)e);
        }
    }
}

