/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import demo.ResourceFolderHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assumptions;
import org.simplejavamail.config.ConfigLoader;
import org.simplejavamail.internal.util.MiscUtil;

public class SecureTestDataHelper {
    private static final String RESOURCES = ResourceFolderHelper.determineResourceFolder("simple-java-mail") + "/test/resources";

    public static void runTestWithSecureTestData(PasswordsConsumer consumer) throws Exception {
        consumer.accept(SecureTestDataHelper.accessSecureTestData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties accessSecureTestData() throws IOException {
        InputStream inputStream = ConfigLoader.class.getClassLoader().getResourceAsStream("secure-testdata-passwords.properties");
        Properties passwords = new Properties();
        passwords.load((InputStream)MiscUtil.checkArgumentNotEmpty((Object)inputStream, (String)"InputStream was null"));
        ((AbstractStringAssert)Assumptions.assumeThat((String)passwords.getProperty("secure-testdata-zip")).as("secure-testdata-passwords.properties", new Object[0])).isNotEmpty();
        Class<SecureTestDataHelper> clazz = SecureTestDataHelper.class;
        synchronized (SecureTestDataHelper.class) {
            if (!new File(RESOURCES + "/secure-testdata/secure-testdata").exists()) {
                String secureDataPassword = passwords.getProperty("secure-testdata-zip");
                new ZipFile(RESOURCES + "/secure-testdata/secure-testdata.zip", secureDataPassword.toCharArray()).extractAll(RESOURCES + "/secure-testdata/secure-testdata");
                new ZipFile(RESOURCES + "/secure-testdata/secure-testdata/file-hider.zip", secureDataPassword.toCharArray()).extractAll(RESOURCES + "/secure-testdata/secure-testdata");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return passwords;
        }
    }

    private static void cleanupSecureTestData() throws IOException {
        FileUtils.forceDeleteOnExit((File)new File(RESOURCES + "/secure-testdata/secure-testdata"));
    }

    public static interface PasswordsConsumer {
        public void accept(Properties var1) throws FileNotFoundException;
    }
}

