/*
 * Decompiled with CFR 0.152.
 */
package demo;

import org.simplejavamail.api.mailer.MailerRegularBuilder;
import org.simplejavamail.api.mailer.config.TransportStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import testutil.ConfigLoaderTestHelper;
import testutil.ImplLoader;

public class DemoAppBase {
    static final Logger LOGGER = LoggerFactory.getLogger(DemoAppBase.class);
    static final String YOUR_GMAIL_ADDRESS = "your_gmail_user@gmail.com";
    static final String YOUR_GMAIL_PASSWORD = "<your password or oauth2 token>";
    private static final boolean LOGGING_MODE = false;
    static final MailerRegularBuilder<?> mailerTLSBuilder;
    static final MailerRegularBuilder<?> mailerSSLBuilder;

    static MailerRegularBuilder<?> buildMailer(String host, int port, String gMailAddress, String gMailPassword, TransportStrategy strategy) {
        return (MailerRegularBuilder)((MailerRegularBuilder)ImplLoader.loadMailerBuilder().withSMTPServer(host, Integer.valueOf(port), gMailAddress, gMailPassword).withSMTPServerPassword(gMailPassword).withTransportStrategy(strategy).withTransportModeLoggingOnly(Boolean.valueOf(false))).clearProxy();
    }

    static {
        ConfigLoaderTestHelper.clearConfigProperties();
        if (YOUR_GMAIL_ADDRESS.equals(YOUR_GMAIL_ADDRESS)) {
            throw new AssertionError((Object)"For these demo's to work, please provide your Gmail credentials in DemoAppBase.java first (or change the SMTP config)");
        }
        mailerTLSBuilder = DemoAppBase.buildMailer("smtp.gmail.com", 587, YOUR_GMAIL_ADDRESS, YOUR_GMAIL_PASSWORD, TransportStrategy.SMTP_TLS);
        mailerSSLBuilder = DemoAppBase.buildMailer("smtp.gmail.com", 465, YOUR_GMAIL_ADDRESS, YOUR_GMAIL_PASSWORD, TransportStrategy.SMTPS);
    }
}

