/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.mailer.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.internal.util.MiscUtil;

public final class Pkcs12Config {
    @NotNull
    private final byte[] pkcs12StoreData;
    @NotNull
    private final char[] storePassword;
    @NotNull
    private final String keyAlias;
    @NotNull
    private final char[] keyPassword;

    private Pkcs12Config(byte @NotNull [] pkcs12StoreData, @NotNull char[] storePassword, @NotNull String keyAlias, @NotNull char[] keyPassword) {
        this.pkcs12StoreData = (byte[])pkcs12StoreData.clone();
        this.storePassword = storePassword;
        this.keyAlias = keyAlias;
        this.keyPassword = keyPassword;
    }

    @NotNull
    public static Pkcs12ConfigBuilder builder() {
        return new Pkcs12ConfigBuilder();
    }

    @NotNull
    public byte[] getPkcs12StoreData() {
        return (byte[])this.pkcs12StoreData.clone();
    }

    @NotNull
    public char[] getStorePassword() {
        return (char[])this.storePassword.clone();
    }

    @NotNull
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @NotNull
    public char[] getKeyPassword() {
        return (char[])this.keyPassword.clone();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Pkcs12Config{").append("  storePassword=***").append(", keyAlias='").append(this.keyAlias).append('\'').append(", keyPassword=***").append('}');
        return sb.toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pkcs12Config)) {
            return false;
        }
        Pkcs12Config other = (Pkcs12Config)o;
        if (!Arrays.equals(this.getPkcs12StoreData(), other.getPkcs12StoreData())) {
            return false;
        }
        if (!Arrays.equals(this.getStorePassword(), other.getStorePassword())) {
            return false;
        }
        String this$keyAlias = this.getKeyAlias();
        String other$keyAlias = other.getKeyAlias();
        if (this$keyAlias == null ? other$keyAlias != null : !this$keyAlias.equals(other$keyAlias)) {
            return false;
        }
        return Arrays.equals(this.getKeyPassword(), other.getKeyPassword());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getPkcs12StoreData());
        result = result * 59 + Arrays.hashCode(this.getStorePassword());
        String $keyAlias = this.getKeyAlias();
        result = result * 59 + ($keyAlias == null ? 43 : $keyAlias.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeyPassword());
        return result;
    }

    public static class Pkcs12ConfigBuilder {
        private byte[] pkcs12StoreData;
        private char[] storePassword;
        private String keyAlias;
        private char[] keyPassword;

        private Pkcs12ConfigBuilder() {
        }

        public Pkcs12ConfigBuilder pkcs12Store(String pkcs12StorePath) {
            return this.pkcs12Store(new File(pkcs12StorePath));
        }

        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Input stream is meant to travel outside method")
        public Pkcs12ConfigBuilder pkcs12Store(File pkcs12StorePath) {
            try {
                return this.pkcs12Store(new FileInputStream(pkcs12StorePath));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("error reading PKCS12 store from File [%s]", pkcs12StorePath), e);
            }
        }

        public Pkcs12ConfigBuilder pkcs12Store(InputStream pkcs12StoreStream) throws IOException {
            this.pkcs12StoreData = MiscUtil.readInputStreamToBytes(pkcs12StoreStream);
            return this;
        }

        public Pkcs12ConfigBuilder pkcs12Store(byte[] pkcs12StoreData) {
            this.pkcs12StoreData = (byte[])pkcs12StoreData.clone();
            return this;
        }

        public Pkcs12ConfigBuilder storePassword(char[] storePassword) {
            this.storePassword = (char[])storePassword.clone();
            return this;
        }

        public Pkcs12ConfigBuilder storePassword(String storePassword) {
            this.storePassword = storePassword.toCharArray();
            return this;
        }

        public Pkcs12ConfigBuilder keyAlias(String keyAlias) {
            this.keyAlias = keyAlias;
            return this;
        }

        public Pkcs12ConfigBuilder keyPassword(char[] keyPassword) {
            this.keyPassword = (char[])keyPassword.clone();
            return this;
        }

        public Pkcs12ConfigBuilder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword.toCharArray();
            return this;
        }

        public Pkcs12Config build() {
            return new Pkcs12Config(this.pkcs12StoreData, this.storePassword, this.keyAlias, this.keyPassword);
        }
    }
}

