/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.internal.clisupport.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.internal.clisupport.model.CliBuilderApiType;
import org.simplejavamail.api.internal.clisupport.model.CliDeclaredOptionValue;

public class CliDeclaredOptionSpec
implements Comparable<CliDeclaredOptionSpec> {
    @NotNull
    private final String name;
    @NotNull
    private final List<String> description;
    @NotNull
    private final CliBuilderApiType fromBuilderApiType;
    @NotNull
    private final List<CliDeclaredOptionValue> possibleOptionValues;
    @NotNull
    private final Method sourceMethod;

    public CliDeclaredOptionSpec(@NotNull String name, @NotNull List<String> description, @NotNull List<CliDeclaredOptionValue> possibleArguments, @NotNull CliBuilderApiType fromBuilderApiType, @NotNull Method sourceMethod) {
        this.name = name;
        this.description = Collections.unmodifiableList(description);
        this.fromBuilderApiType = fromBuilderApiType;
        this.possibleOptionValues = Collections.unmodifiableList(possibleArguments);
        this.sourceMethod = sourceMethod;
    }

    public String toString() {
        return this.name;
    }

    public boolean applicableToRootCommand(Collection<CliBuilderApiType> compatibleBuilderApiTypes) {
        return compatibleBuilderApiTypes.contains((Object)this.fromBuilderApiType);
    }

    public List<CliDeclaredOptionValue> getMandatoryOptionValues() {
        ArrayList<CliDeclaredOptionValue> mandatoryOptionValues = new ArrayList<CliDeclaredOptionValue>();
        for (CliDeclaredOptionValue optionValue : this.possibleOptionValues) {
            if (!optionValue.isRequired()) continue;
            mandatoryOptionValues.add(optionValue);
        }
        return mandatoryOptionValues;
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public int compareTo(@NotNull CliDeclaredOptionSpec other) {
        int prefixOrder = this.getNamePrefix().compareTo(other.getNamePrefix());
        return prefixOrder != 0 ? prefixOrder : this.getNameAfterPrefix().compareTo(other.getNameAfterPrefix());
    }

    private String getNamePrefix() {
        return this.getName().substring(0, this.getName().indexOf(":"));
    }

    private String getNameAfterPrefix() {
        return this.getName().substring(this.getName().indexOf(":"));
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getDescription() {
        return this.description;
    }

    @NotNull
    public List<CliDeclaredOptionValue> getPossibleOptionValues() {
        return this.possibleOptionValues;
    }

    @NotNull
    public Method getSourceMethod() {
        return this.sourceMethod;
    }
}

