/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.config;

import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.Email;

public enum EmailProperty {
    HEADERS(Email::getHeaders, true),
    SUBJECT(Email::getSubject, false),
    BODY_TEXT(Email::getPlainText, false),
    BODY_HTML(Email::getHTMLText, false),
    CALENDAR_METHOD(Email::getCalendarMethod, false),
    CALENDAR_TEXT(Email::getCalendarText, false),
    ATTACHMENTS(Email::getAttachments, true),
    EMBEDDED_IMAGES(Email::getEmbeddedImages, true),
    RETURN_RECEIPT_TO(Email::getReturnReceiptTo, false),
    DISPOSITION_NOTIFICATION_TO(Email::getDispositionNotificationTo, false),
    USE_RETURN_RECEIPT_TO(Email::getUseReturnReceiptTo, false),
    USE_DISPOSITION_NOTIFICATION_TO(Email::getUseDispositionNotificationTo, false),
    CONTENT_TRANSFER_ENCODING(Email::getContentTransferEncoding, false),
    FROM_RECIPIENT(Email::getFromRecipient, false),
    REPLYTO_RECIPIENT(Email::getReplyToRecipient, false),
    BOUNCETO_RECIPIENT(Email::getBounceToRecipient, false),
    ALL_RECIPIENTS(Email::getRecipients, true),
    TO_RECIPIENTS(Email::getToRecipients, true),
    CC_RECIPIENTS(Email::getCcRecipients, true),
    BCC_RECIPIENTS(Email::getBccRecipients, true),
    SMIME_SIGNING_CONFIG(Email::getPkcs12ConfigForSmimeSigning, false),
    SMIME_ENCRYPTION_CONFIG(Email::getX509CertificateForSmimeEncryption, false),
    DKIM_SIGNING_CONFIG(Email::getDkimConfig, false),
    SENT_DATE(Email::getSentDate, false),
    ID(Email::getId, false),
    MAIL_TO_FORWARD(Email::getEmailToForward, false);

    private final Function<@NotNull Email, @Nullable Object> getter;
    private final boolean isCollectionValue;

    public <T> Function<@NotNull Email, @Nullable T> getGetter() {
        return this.getter;
    }

    private EmailProperty(Function<Email, Object> getter, boolean isCollectionValue) {
        this.getter = getter;
        this.isCollectionValue = isCollectionValue;
    }

    public boolean isCollectionValue() {
        return this.isCollectionValue;
    }
}

