/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.MiscUtil;

public class DkimConfig
implements Serializable {
    private static final long serialVersionUID = 1234567L;
    private final byte[] dkimPrivateKeyData;
    private final String dkimSigningDomain;
    private final String dkimSelector;
    @Nullable
    private final Set<String> excludedHeadersFromDkimDefaultSigningList;

    DkimConfig(byte[] dkimPrivateKeyData, String dkimSigningDomain, String dkimSelector, @Nullable Set<String> excludedHeadersFromDkimDefaultSigningList) {
        this.dkimPrivateKeyData = (byte[])dkimPrivateKeyData.clone();
        this.dkimSigningDomain = dkimSigningDomain;
        this.dkimSelector = dkimSelector;
        this.excludedHeadersFromDkimDefaultSigningList = excludedHeadersFromDkimDefaultSigningList;
    }

    public byte[] getDkimPrivateKeyData() {
        return (byte[])this.dkimPrivateKeyData.clone();
    }

    public static DkimConfigBuilder builder() {
        return new DkimConfigBuilder();
    }

    public String toString() {
        return "DkimConfig(dkimSigningDomain=" + this.getDkimSigningDomain() + ", dkimSelector=" + this.getDkimSelector() + ", excludedHeadersFromDkimDefaultSigningList=" + this.getExcludedHeadersFromDkimDefaultSigningList() + ")";
    }

    public String getDkimSigningDomain() {
        return this.dkimSigningDomain;
    }

    public String getDkimSelector() {
        return this.dkimSelector;
    }

    @Nullable
    public Set<String> getExcludedHeadersFromDkimDefaultSigningList() {
        return this.excludedHeadersFromDkimDefaultSigningList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DkimConfig)) {
            return false;
        }
        DkimConfig other = (DkimConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getDkimPrivateKeyData(), other.getDkimPrivateKeyData())) {
            return false;
        }
        String this$dkimSigningDomain = this.getDkimSigningDomain();
        String other$dkimSigningDomain = other.getDkimSigningDomain();
        if (this$dkimSigningDomain == null ? other$dkimSigningDomain != null : !this$dkimSigningDomain.equals(other$dkimSigningDomain)) {
            return false;
        }
        String this$dkimSelector = this.getDkimSelector();
        String other$dkimSelector = other.getDkimSelector();
        if (this$dkimSelector == null ? other$dkimSelector != null : !this$dkimSelector.equals(other$dkimSelector)) {
            return false;
        }
        Set<String> this$excludedHeadersFromDkimDefaultSigningList = this.getExcludedHeadersFromDkimDefaultSigningList();
        Set<String> other$excludedHeadersFromDkimDefaultSigningList = other.getExcludedHeadersFromDkimDefaultSigningList();
        return !(this$excludedHeadersFromDkimDefaultSigningList == null ? other$excludedHeadersFromDkimDefaultSigningList != null : !((Object)this$excludedHeadersFromDkimDefaultSigningList).equals(other$excludedHeadersFromDkimDefaultSigningList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DkimConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getDkimPrivateKeyData());
        String $dkimSigningDomain = this.getDkimSigningDomain();
        result = result * 59 + ($dkimSigningDomain == null ? 43 : $dkimSigningDomain.hashCode());
        String $dkimSelector = this.getDkimSelector();
        result = result * 59 + ($dkimSelector == null ? 43 : $dkimSelector.hashCode());
        Set<String> $excludedHeadersFromDkimDefaultSigningList = this.getExcludedHeadersFromDkimDefaultSigningList();
        result = result * 59 + ($excludedHeadersFromDkimDefaultSigningList == null ? 43 : ((Object)$excludedHeadersFromDkimDefaultSigningList).hashCode());
        return result;
    }

    public static class DkimConfigBuilder {
        private byte[] dkimPrivateKeyData;
        private String dkimSigningDomain;
        private String dkimSelector;
        @Nullable
        private Set<String> excludedHeadersFromDkimDefaultSigningList;

        DkimConfigBuilder() {
        }

        public DkimConfigBuilder dkimPrivateKeyPath(String dkimPrivateKeyFile) {
            return this.dkimPrivateKeyPath(new File(dkimPrivateKeyFile));
        }

        public DkimConfigBuilder dkimPrivateKeyPath(File dkimPrivateKeyFile) {
            try (FileInputStream dkimPrivateKeyInputStream = new FileInputStream(dkimPrivateKeyFile);){
                this.dkimPrivateKeyData(dkimPrivateKeyInputStream);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("error reading DKIM private key file[%s]", dkimPrivateKeyFile), e);
            }
            return this;
        }

        public DkimConfigBuilder dkimPrivateKeyData(InputStream dkimPrivateKeyInputStream) {
            try {
                this.dkimPrivateKeyData(MiscUtil.readInputStreamToBytes(dkimPrivateKeyInputStream));
            }
            catch (IOException e) {
                throw new IllegalStateException("error reading DKIM private key inputstream", e);
            }
            return this;
        }

        public DkimConfigBuilder dkimPrivateKeyData(String dkimPrivateKeyData) {
            this.dkimPrivateKeyData(dkimPrivateKeyData.getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public DkimConfigBuilder dkimPrivateKeyData(byte[] dkimPrivateKeyData) {
            this.dkimPrivateKeyData = (byte[])dkimPrivateKeyData.clone();
            return this;
        }

        public DkimConfigBuilder dkimSigningDomain(String dkimSigningDomain) {
            this.dkimSigningDomain = dkimSigningDomain;
            return this;
        }

        public DkimConfigBuilder dkimSelector(String dkimSelector) {
            this.dkimSelector = dkimSelector;
            return this;
        }

        public DkimConfigBuilder excludedHeadersFromDkimDefaultSigningList(@Nullable Set<String> excludedHeadersFromDkimDefaultSigningList) {
            this.excludedHeadersFromDkimDefaultSigningList = excludedHeadersFromDkimDefaultSigningList;
            return this;
        }

        public DkimConfigBuilder excludedHeadersFromDkimDefaultSigningList(String ... excludedHeadersFromDkimDefaultSigningList) {
            this.excludedHeadersFromDkimDefaultSigningList = new HashSet<String>(Arrays.asList(excludedHeadersFromDkimDefaultSigningList));
            return this;
        }

        public DkimConfig build() {
            return new DkimConfig(this.dkimPrivateKeyData, this.dkimSigningDomain, this.dkimSelector, this.excludedHeadersFromDkimDefaultSigningList);
        }

        public String toString() {
            return "DkimConfig.DkimConfigBuilder(dkimPrivateKeyData=" + Arrays.toString(this.dkimPrivateKeyData) + ", dkimSigningDomain=" + this.dkimSigningDomain + ", dkimSelector=" + this.dkimSelector + ", excludedHeadersFromDkimDefaultSigningList=" + this.excludedHeadersFromDkimDefaultSigningList + ")";
        }
    }
}

