/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public enum ContentTransferEncoding {
    BASE_64("base64"),
    B("b"),
    Q("q"),
    BINARY("binary"),
    BIT7("7bit"),
    BIT8("8bit"),
    QUOTED_PRINTABLE("quoted-printable"),
    UU("uuencode"),
    X_UU("x-uuencode"),
    X_UUE("x-uue");

    private final String encoder;

    public static ContentTransferEncoding byEncoder(@NotNull String encoder) {
        return Arrays.stream(ContentTransferEncoding.values()).filter(c -> c.encoder.equals(encoder)).findFirst().orElseThrow(() -> new IllegalArgumentException("unknown content transfer encoder: " + encoder));
    }

    public String toString() {
        return this.encoder;
    }

    private ContentTransferEncoding(String encoder) {
        this.encoder = encoder;
    }

    public String getEncoder() {
        return this.encoder;
    }
}

