/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email;

import jakarta.activation.DataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.MailException;
import org.simplejavamail.api.email.EqualsHelper;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;

public class AttachmentResource
implements Serializable {
    private static final long serialVersionUID = 1234567L;
    private final String name;
    private final transient DataSource dataSource;

    public AttachmentResource(@Nullable String name, @NotNull DataSource dataSource) {
        this.name = name;
        this.dataSource = Preconditions.checkNonEmptyArgument(dataSource, "dataSource");
    }

    @NotNull
    public String readAllData() throws IOException {
        return this.readAllData(StandardCharsets.UTF_8);
    }

    @NotNull
    public byte[] readAllBytes() throws IOException {
        return MiscUtil.readInputStreamToBytes(this.getDataSourceInputStream());
    }

    @NotNull
    public String readAllData(@NotNull Charset charset) throws IOException {
        Preconditions.checkNonEmptyArgument(charset, "charset");
        return MiscUtil.readInputStreamToString(this.getDataSourceInputStream(), charset);
    }

    @NotNull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public InputStream getDataSourceInputStream() {
        try {
            return this.dataSource.getInputStream();
        }
        catch (IOException e) {
            throw new AttachmentResourceException("Error getting input stream from attachment's data source", e);
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentResource that = (AttachmentResource)o;
        return Objects.equals(this.name, that.name) && EqualsHelper.isEqualDataSource(this.dataSource, that.dataSource);
    }

    @NotNull
    public String toString() {
        return "AttachmentResource{\n\t\tname='" + this.name + '\'' + ",\n\t\tdataSource.name=" + this.dataSource.getName() + ",\n\t\tdataSource.getContentType=" + this.dataSource.getContentType() + "\n\t}";
    }

    private static class AttachmentResourceException
    extends MailException {
        protected AttachmentResourceException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

