/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.internal.util.Preconditions;

public final class MiscUtil {
    private static final Pattern MATCH_INSIDE_CIDBRACKETS = Pattern.compile("<?([^>]*)>?");
    private static final Pattern COMMA_DELIMITER_PATTERN = Pattern.compile("(@.*?>?)\\s*[,;]");
    private static final Pattern TRAILING_TOKEN_DELIMITER_PATTERN = Pattern.compile("<\\|>$");
    private static final Pattern TOKEN_DELIMITER_PATTERN = Pattern.compile("\\s*<\\|>\\s*");

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public static <T> T checkNotNull(@Nullable T value, @Nullable String msg) {
        if (value == null) {
            throw new NullPointerException(msg);
        }
        return value;
    }

    public static <T> T checkArgumentNotEmpty(@Nullable T value, @Nullable String msg) {
        if (MiscUtil.valueNullOrEmpty(value)) {
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    public static <T> boolean valueNullOrEmpty(@Nullable T value) {
        return value == null || value instanceof String && ((String)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof byte[] && ((byte[])value).length == 0;
    }

    public static String buildLogStringForSOCKSCommunication(byte[] bytes, boolean isReceived) {
        StringBuilder debugMsg = new StringBuilder();
        debugMsg.append(isReceived ? "Received: " : "Sent: ");
        for (byte aByte : bytes) {
            debugMsg.append(Integer.toHexString(MiscUtil.toInt(aByte))).append(" ");
        }
        return debugMsg.toString();
    }

    public static int toInt(byte b) {
        return b & 0xFF;
    }

    @Nullable
    public static String encodeText(@Nullable String name) {
        if (name == null) {
            return null;
        }
        try {
            return MimeUtility.encodeText((String)name, (String)StandardCharsets.UTF_8.name(), (String)"B");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Nullable
    public static String extractCID(@Nullable String cid) {
        return cid != null ? MATCH_INSIDE_CIDBRACKETS.matcher(cid).replaceAll("$1") : null;
    }

    @NotNull
    public static String readInputStreamToString(@NotNull InputStream inputStream, @NotNull Charset charset) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int result = bufferedInputStream.read();
        while (result != -1) {
            byteArrayOutputStream.write((byte)result);
            result = bufferedInputStream.read();
        }
        return byteArrayOutputStream.toString(Preconditions.checkNonEmptyArgument(charset, "charset").name());
    }

    @NotNull
    public static byte[] readInputStreamToBytes(@NotNull InputStream inputStream) throws IOException {
        byte[] targetArray = new byte[inputStream.available()];
        inputStream.read(targetArray);
        return targetArray;
    }

    @NotNull
    public static String[] extractEmailAddresses(@NotNull String emailAddressList) {
        Preconditions.checkNonEmptyArgument(emailAddressList, "emailAddressList");
        String unambiguousDelimitedList = COMMA_DELIMITER_PATTERN.matcher(emailAddressList).replaceAll("$1<|>");
        String withoutTrailingDelimeter = TRAILING_TOKEN_DELIMITER_PATTERN.matcher(unambiguousDelimitedList).replaceAll("");
        return TOKEN_DELIMITER_PATTERN.split(withoutTrailingDelimeter, 0);
    }

    @NotNull
    public static Recipient interpretRecipient(@Nullable String name, boolean fixedName, @NotNull String emailAddress, @Nullable Message.RecipientType type) {
        try {
            InternetAddress parsedAddress = InternetAddress.parse((String)emailAddress, (boolean)false)[0];
            String relevantName = fixedName || parsedAddress.getPersonal() == null ? MiscUtil.defaultTo(name, parsedAddress.getPersonal()) : MiscUtil.defaultTo(parsedAddress.getPersonal(), name);
            return new Recipient(relevantName, parsedAddress.getAddress(), type);
        }
        catch (AddressException e) {
            return new Recipient(name, emailAddress, type);
        }
    }

    @Nullable
    public static <T> T defaultTo(@Nullable T value, @Nullable T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean classAvailable(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public static <T1, T2> Map.Entry<T1, T2>[] zip(T1[] zipLeft, T2[] zipRight) {
        return MiscUtil.zip(Arrays.asList(zipLeft), Arrays.asList(zipRight)).toArray(new Map.Entry[0]);
    }

    public static <T1, T2> List<Map.Entry<T1, T2>> zip(List<T1> zipLeft, List<T2> zipRight) {
        Preconditions.assumeTrue(zipLeft.size() == zipRight.size(), "Can't zip lists, sizes are not equals");
        ArrayList<Map.Entry<T1, T2>> zipped = new ArrayList<Map.Entry<T1, T2>>();
        for (int i = 0; i < zipLeft.size(); ++i) {
            zipped.add(new AbstractMap.SimpleEntry<T1, T2>(zipLeft.get(i), zipRight.get(i)));
        }
        return zipped;
    }

    @Nullable
    public static String normalizeNewlines(@Nullable String text) {
        return text == null ? null : text.replaceAll("\\r\\n", "\n").replaceAll("\\r", "\n");
    }

    public static int countMandatoryParameters(@NotNull Method m) {
        int mandatoryParameterCount = 0;
        for (Annotation[] annotations : m.getParameterAnnotations()) {
            mandatoryParameterCount += !MiscUtil.containsNullableAnnotation(annotations) ? 1 : 0;
        }
        return mandatoryParameterCount;
    }

    private static boolean containsNullableAnnotation(Annotation[] annotations) {
        for (Annotation annotation : (Annotation[])annotations.clone()) {
            if (annotation.annotationType() != Nullable.class) continue;
            return true;
        }
        return false;
    }

    public static String readFileContent(@NotNull File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("File not found: %s", file));
        }
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
    }

    public static boolean inputStreamEqual(InputStream inputOrg1, InputStream inputOrg2) {
        int ch2;
        ByteArrayInputStream input1 = MiscUtil.copyInputstream(inputOrg1);
        ByteArrayInputStream input2 = MiscUtil.copyInputstream(inputOrg2);
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static ByteArrayInputStream copyInputstream(InputStream input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = input.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            if (input instanceof FileInputStream) {
                ((FileInputStream)input).getChannel().position(0L);
            } else {
                input.reset();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

