/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.internal.clisupport.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.internal.clisupport.model.CliBuilderApiType;
import org.simplejavamail.api.internal.clisupport.model.CliDeclaredOptionValue;

public class CliDeclaredOptionSpec
implements Comparable<CliDeclaredOptionSpec> {
    @NotNull
    private final String name;
    @NotNull
    private final List<String> description;
    @NotNull
    private final CliBuilderApiType fromBuilderApiType;
    @NotNull
    private final List<CliDeclaredOptionValue> possibleOptionValues;
    @NotNull
    private final Method sourceMethod;

    public CliDeclaredOptionSpec(@NotNull String name, @NotNull List<String> description, @NotNull List<CliDeclaredOptionValue> possibleArguments, @NotNull CliBuilderApiType fromBuilderApiType, @NotNull Method sourceMethod) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.<init> must not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.<init> must not be null");
        }
        if (possibleArguments == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.<init> must not be null");
        }
        if (fromBuilderApiType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.<init> must not be null");
        }
        if (sourceMethod == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 4 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.<init> must not be null");
        }
        this.name = name;
        this.description = Collections.unmodifiableList(description);
        this.fromBuilderApiType = fromBuilderApiType;
        this.possibleOptionValues = Collections.unmodifiableList(possibleArguments);
        this.sourceMethod = sourceMethod;
    }

    public String toString() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.toString must not return null");
        }
        return string;
    }

    public boolean applicableToRootCommand(Collection<CliBuilderApiType> compatibleBuilderApiTypes) {
        if (compatibleBuilderApiTypes == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.applicableToRootCommand must not be null");
        }
        return compatibleBuilderApiTypes.contains((Object)this.fromBuilderApiType);
    }

    public List<CliDeclaredOptionValue> getMandatoryOptionValues() {
        ArrayList<CliDeclaredOptionValue> mandatoryOptionValues = new ArrayList<CliDeclaredOptionValue>();
        for (CliDeclaredOptionValue optionValue : this.possibleOptionValues) {
            if (!optionValue.isRequired()) continue;
            mandatoryOptionValues.add(optionValue);
        }
        ArrayList<CliDeclaredOptionValue> arrayList = mandatoryOptionValues;
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.getMandatoryOptionValues must not return null");
        }
        return arrayList;
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public int compareTo(@NotNull CliDeclaredOptionSpec other) {
        if (other == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.compareTo must not be null");
        }
        int prefixOrder = this.getNamePrefix().compareTo(other.getNamePrefix());
        return prefixOrder != 0 ? prefixOrder : this.getNameAfterPrefix().compareTo(other.getNameAfterPrefix());
    }

    private String getNamePrefix() {
        String string = this.getName().substring(0, this.getName().indexOf(":"));
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.getNamePrefix must not return null");
        }
        return string;
    }

    private String getNameAfterPrefix() {
        String string = this.getName().substring(this.getName().indexOf(":"));
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.getNameAfterPrefix must not return null");
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.getName must not return null");
        }
        return string;
    }

    @NotNull
    public List<String> getDescription() {
        List<String> list = this.description;
        if (list == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.getDescription must not return null");
        }
        return list;
    }

    @NotNull
    public List<CliDeclaredOptionValue> getPossibleOptionValues() {
        List<CliDeclaredOptionValue> list = this.possibleOptionValues;
        if (list == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.getPossibleOptionValues must not return null");
        }
        return list;
    }

    @NotNull
    public Method getSourceMethod() {
        Method method = this.sourceMethod;
        if (method == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/internal/clisupport/model/CliDeclaredOptionSpec.getSourceMethod must not return null");
        }
        return method;
    }
}

