/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.email;

import java.io.Serializable;
import java.util.Objects;
import javax.mail.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.Preconditions;

public final class Recipient
implements Serializable {
    private static final long serialVersionUID = 1234567L;
    @Nullable
    private final String name;
    @NotNull
    private final String address;
    @Nullable
    private final Message.RecipientType type;

    public Recipient(@Nullable String name, @NotNull String address, @Nullable Message.RecipientType type) {
        if (address == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/simplejavamail/api/email/Recipient.<init> must not be null");
        }
        this.name = name;
        this.address = Preconditions.checkNonEmptyArgument(address, "address");
        this.type = type;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipient recipient = (Recipient)o;
        return Objects.equals(this.name, recipient.name) && Objects.equals(this.address, recipient.address) && Objects.equals(this.type, recipient.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.address, this.type);
    }

    @NotNull
    public String toString() {
        String string = "Recipient{name='" + this.name + '\'' + ", address='" + this.address + '\'' + ", type=" + this.type + '}';
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/email/Recipient.toString must not return null");
        }
        return string;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getAddress() {
        String string = this.address;
        if (string == null) {
            throw new IllegalStateException("NotNull method org/simplejavamail/api/email/Recipient.getAddress must not return null");
        }
        return string;
    }

    @Nullable
    public Message.RecipientType getType() {
        return this.type;
    }
}

