/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.reactor;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Arrays;
import org.simpleframework.transport.reactor.Action;

class ActionSet {
    private final SelectionKey key;
    private final Action[] set = new Action[4];

    public ActionSet(SelectionKey key) {
        this.key = key;
    }

    public SelectionKey key() {
        return this.key;
    }

    public SelectableChannel channel() {
        return this.key.channel();
    }

    public Action[] list() {
        Action[] actions = new Action[4];
        int count = 0;
        for (Action action : this.set) {
            if (action == null) continue;
            actions[count++] = action;
        }
        return Arrays.copyOfRange(actions, 0, count);
    }

    public Action[] ready() {
        int ready = this.key.readyOps();
        if (ready != 0) {
            return this.get(ready);
        }
        return new Action[0];
    }

    public void attach(Action action) {
        int interest = action.getInterest();
        if ((interest | 1) == interest) {
            this.set[0] = action;
        }
        if ((interest | 4) == interest) {
            this.set[1] = action;
        }
        if ((interest | 0x10) == interest) {
            this.set[2] = action;
        }
        if ((interest | 8) == interest) {
            this.set[3] = action;
        }
    }

    public Action[] remove(int interest) {
        Action[] actions = this.get(interest);
        if ((interest | 1) == interest) {
            this.set[0] = null;
        }
        if ((interest | 4) == interest) {
            this.set[1] = null;
        }
        if ((interest | 0x10) == interest) {
            this.set[2] = null;
        }
        if ((interest | 8) == interest) {
            this.set[3] = null;
        }
        return actions;
    }

    public Action[] get(int interest) {
        Action[] actions = new Action[4];
        int count = 0;
        if ((interest | 1) == interest && this.set[0] != null) {
            actions[count++] = this.set[0];
        }
        if ((interest | 4) == interest && this.set[1] != null) {
            actions[count++] = this.set[1];
        }
        if ((interest | 0x10) == interest && this.set[2] != null) {
            actions[count++] = this.set[2];
        }
        if ((interest | 8) == interest && this.set[3] != null) {
            actions[count++] = this.set[3];
        }
        return Arrays.copyOfRange(actions, 0, count);
    }

    public int interest() {
        int interest = 0;
        if (this.set[0] != null) {
            interest |= 1;
        }
        if (this.set[1] != null) {
            interest |= 4;
        }
        if (this.set[2] != null) {
            interest |= 0x10;
        }
        if (this.set[3] != null) {
            interest |= 8;
        }
        return interest;
    }

    public void clear() {
        this.set[3] = null;
        this.set[2] = null;
        this.set[1] = null;
        this.set[0] = null;
    }

    public void cancel() {
        this.key.cancel();
    }
}

