/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.Default;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.NamespaceList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Complete;
import org.simpleframework.xml.core.ConstructorScanner;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.Function;
import org.simpleframework.xml.core.NamespaceDecorator;
import org.simpleframework.xml.core.ParameterMap;
import org.simpleframework.xml.core.Persist;
import org.simpleframework.xml.core.Replace;
import org.simpleframework.xml.core.Resolve;
import org.simpleframework.xml.core.Signature;
import org.simpleframework.xml.core.Validate;
import org.simpleframework.xml.stream.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassScanner {
    private NamespaceDecorator decorator;
    private ConstructorScanner scanner;
    private Namespace namespace;
    private Function commit;
    private Function validate;
    private Function persist;
    private Function complete;
    private Function replace;
    private Function resolve;
    private Default access;
    private Order order;
    private Root root;

    public ClassScanner(Class type, Format format) throws Exception {
        this.scanner = new ConstructorScanner(type, format);
        this.decorator = new NamespaceDecorator();
        this.scan(type);
    }

    public Signature getSignature() {
        return this.scanner.getSignature();
    }

    public List<Signature> getSignatures() {
        return this.scanner.getSignatures();
    }

    public ParameterMap getParameters() {
        return this.scanner.getParameters();
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public Default getDefault() {
        return this.access;
    }

    public Order getOrder() {
        return this.order;
    }

    public Root getRoot() {
        return this.root;
    }

    public Function getCommit() {
        return this.commit;
    }

    public Function getValidate() {
        return this.validate;
    }

    public Function getPersist() {
        return this.persist;
    }

    public Function getComplete() {
        return this.complete;
    }

    public Function getReplace() {
        return this.replace;
    }

    public Function getResolve() {
        return this.resolve;
    }

    public boolean isStrict() {
        if (this.root != null) {
            return this.root.strict();
        }
        return true;
    }

    private void scan(Class type) throws Exception {
        Class real = type;
        while (type != null) {
            this.global(type);
            this.scan(real, type);
            type = type.getSuperclass();
        }
        this.process(real);
    }

    private void global(Class type) throws Exception {
        Annotation[] list;
        for (Annotation label : list = type.getDeclaredAnnotations()) {
            if (label instanceof Namespace) {
                this.namespace(label);
            }
            if (label instanceof NamespaceList) {
                this.scope(label);
            }
            if (label instanceof Root) {
                this.root(label);
            }
            if (label instanceof Order) {
                this.order(label);
            }
            if (!(label instanceof Default)) continue;
            this.access(label);
        }
    }

    private void scan(Class real, Class type) throws Exception {
        Method[] method = type.getDeclaredMethods();
        for (int i = 0; i < method.length; ++i) {
            this.scan(method[i]);
        }
    }

    private void root(Annotation label) {
        if (this.root == null) {
            this.root = (Root)label;
        }
    }

    private void order(Annotation label) {
        if (this.order == null) {
            this.order = (Order)label;
        }
    }

    private void access(Annotation label) {
        if (this.access == null) {
            this.access = (Default)label;
        }
    }

    private void namespace(Annotation label) {
        if (label != null) {
            this.namespace = (Namespace)label;
            if (this.namespace != null) {
                this.decorator.add(this.namespace);
            }
        }
    }

    private void scope(Annotation label) {
        if (label != null) {
            Namespace[] list;
            NamespaceList scope = (NamespaceList)label;
            for (Namespace name : list = scope.value()) {
                this.decorator.add(name);
            }
        }
    }

    private void process(Class type) {
        if (this.namespace != null) {
            this.decorator.set(this.namespace);
        }
    }

    private void scan(Method method) {
        Annotation[] list;
        for (Annotation label : list = method.getDeclaredAnnotations()) {
            if (label instanceof Commit) {
                this.commit(method);
            }
            if (label instanceof Validate) {
                this.validate(method);
            }
            if (label instanceof Persist) {
                this.persist(method);
            }
            if (label instanceof Complete) {
                this.complete(method);
            }
            if (label instanceof Replace) {
                this.replace(method);
            }
            if (!(label instanceof Resolve)) continue;
            this.resolve(method);
        }
    }

    private void replace(Method method) {
        if (this.replace == null) {
            this.replace = this.getFunction(method);
        }
    }

    private void resolve(Method method) {
        if (this.resolve == null) {
            this.resolve = this.getFunction(method);
        }
    }

    private void commit(Method method) {
        if (this.commit == null) {
            this.commit = this.getFunction(method);
        }
    }

    private void validate(Method method) {
        if (this.validate == null) {
            this.validate = this.getFunction(method);
        }
    }

    private void persist(Method method) {
        if (this.persist == null) {
            this.persist = this.getFunction(method);
        }
    }

    private void complete(Method method) {
        if (this.complete == null) {
            this.complete = this.getFunction(method);
        }
    }

    private Function getFunction(Method method) {
        boolean contextual = this.isContextual(method);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return new Function(method, contextual);
    }

    private boolean isContextual(Method method) {
        Class<?>[] list = method.getParameterTypes();
        if (list.length == 1) {
            return Map.class.equals(list[0]);
        }
        return false;
    }
}

