/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Variant;
import org.simpleframework.xml.core.CompositeVariant;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.ElementLabel;
import org.simpleframework.xml.core.GroupExtractor;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.OverrideType;
import org.simpleframework.xml.core.VariantException;
import org.simpleframework.xml.strategy.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class VariantLabel
implements Label {
    private final GroupExtractor extractor;
    private final Variant variant;
    private final Contact contact;
    private final Label label;

    public VariantLabel(Contact contact, Variant variant, Element element) throws Exception {
        this.extractor = new GroupExtractor(contact, variant);
        this.label = new ElementLabel(contact, element);
        this.variant = variant;
        this.contact = contact;
    }

    @Override
    public Contact getContact() {
        return this.contact;
    }

    @Override
    public Annotation getAnnotation() {
        return this.label.getAnnotation();
    }

    @Override
    public Label getLabel(Class type) throws Exception {
        Contact contact = this.getContact();
        if (!this.extractor.isValid(type)) {
            throw new VariantException("No type matches %s in %s for %s", type, this.variant, contact);
        }
        return this.extractor.getLabel(type);
    }

    @Override
    public Type getType(Class type) throws Exception {
        Contact contact = this.getContact();
        if (!this.extractor.isValid(type)) {
            throw new VariantException("No type matches %s in %s for %s", type, this.variant, contact);
        }
        return new OverrideType(contact, type);
    }

    @Override
    public Converter getConverter(Context context) throws Exception {
        Contact type = this.getContact();
        if (type == null) {
            throw new VariantException("Variant %s was not declared on a field or method", this.label);
        }
        return new CompositeVariant(context, this.extractor, type);
    }

    @Override
    public Set<String> getVariants() throws Exception {
        return this.extractor.getNames();
    }

    @Override
    public Set<String> getVariants(Context context) throws Exception {
        return this.extractor.getNames(context);
    }

    @Override
    public Object getEmpty(Context context) throws Exception {
        return this.label.getEmpty(context);
    }

    @Override
    public String getName(Context context) throws Exception {
        return this.label.getName(context);
    }

    @Override
    public Decorator getDecorator() throws Exception {
        return this.label.getDecorator();
    }

    @Override
    public Type getDependent() throws Exception {
        return this.label.getDependent();
    }

    @Override
    public String getEntry() throws Exception {
        return this.label.getEntry();
    }

    @Override
    public String getName() throws Exception {
        return this.label.getName();
    }

    @Override
    public String getOverride() {
        return this.label.getOverride();
    }

    @Override
    public String getPath() {
        return this.label.getPath();
    }

    @Override
    public Class getType() {
        return this.label.getType();
    }

    @Override
    public boolean isAttribute() {
        return this.label.isAttribute();
    }

    @Override
    public boolean isCollection() {
        return this.label.isCollection();
    }

    @Override
    public boolean isData() {
        return this.label.isData();
    }

    @Override
    public boolean isInline() {
        return this.label.isInline();
    }

    @Override
    public boolean isRequired() {
        return this.label.isRequired();
    }
}

