/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.core.ClassType;
import org.simpleframework.xml.core.CollectionFactory;
import org.simpleframework.xml.core.CompositeInlineList;
import org.simpleframework.xml.core.CompositeList;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.Introspector;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.PrimitiveInlineList;
import org.simpleframework.xml.core.PrimitiveList;
import org.simpleframework.xml.core.Qualifier;
import org.simpleframework.xml.strategy.Type;
import org.simpleframework.xml.stream.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementListLabel
implements Label {
    private Decorator decorator;
    private ElementList label;
    private Introspector detail;
    private Class type;
    private Class item;
    private String entry;
    private String name;

    public ElementListLabel(Contact contact, ElementList label) {
        this.detail = new Introspector(contact, this);
        this.decorator = new Qualifier(contact);
        this.type = contact.getType();
        this.entry = label.entry();
        this.item = label.type();
        this.name = label.name();
        this.label = label;
    }

    @Override
    public Type getType(Class type) {
        return this.getContact();
    }

    @Override
    public Label getLabel(Class type) {
        return this;
    }

    @Override
    public Set<String> getUnion() throws Exception {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getUnion(Context context) throws Exception {
        return Collections.emptySet();
    }

    @Override
    public Decorator getDecorator() throws Exception {
        return this.decorator;
    }

    @Override
    public Converter getConverter(Context context) throws Exception {
        String entry = this.getEntry(context);
        if (!this.label.inline()) {
            return this.getConverter(context, entry);
        }
        return this.getInlineConverter(context, entry);
    }

    private Converter getConverter(Context context, String name) throws Exception {
        Type item = this.getDependent();
        Contact type = this.getContact();
        if (!context.isPrimitive(item)) {
            return new CompositeList(context, type, item, name);
        }
        return new PrimitiveList(context, type, item, name);
    }

    private Converter getInlineConverter(Context context, String name) throws Exception {
        Type item = this.getDependent();
        Contact type = this.getContact();
        if (!context.isPrimitive(item)) {
            return new CompositeInlineList(context, type, item, name);
        }
        return new PrimitiveInlineList(context, type, item, name);
    }

    @Override
    public String getName(Context context) throws Exception {
        Style style = context.getStyle();
        String name = this.detail.getName();
        return style.getElement(name);
    }

    private String getEntry(Context context) throws Exception {
        Style style = context.getStyle();
        String entry = this.getEntry();
        return style.getElement(entry);
    }

    @Override
    public Object getEmpty(Context context) throws Exception {
        ClassType list = new ClassType(this.type);
        CollectionFactory factory = new CollectionFactory(context, list);
        if (!this.label.empty()) {
            return ((Factory)factory).getInstance();
        }
        return null;
    }

    @Override
    public Type getDependent() throws Exception {
        Contact contact = this.getContact();
        if (this.item == Void.TYPE) {
            this.item = contact.getDependent();
        }
        if (this.item == null) {
            throw new ElementException("Unable to determine generic type for %s", contact);
        }
        return new ClassType(this.item);
    }

    @Override
    public String getEntry() throws Exception {
        if (this.detail.isEmpty(this.entry)) {
            this.entry = this.detail.getEntry();
        }
        return this.entry;
    }

    @Override
    public String getName() throws Exception {
        return this.detail.getName();
    }

    @Override
    public Annotation getAnnotation() {
        return this.label;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Contact getContact() {
        return this.detail.getContact();
    }

    @Override
    public String getPath() {
        return this.detail.getPath();
    }

    @Override
    public String getOverride() {
        return this.name;
    }

    @Override
    public boolean isData() {
        return this.label.data();
    }

    @Override
    public boolean isAttribute() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return this.label.required();
    }

    @Override
    public boolean isInline() {
        return this.label.inline();
    }

    @Override
    public String toString() {
        return this.detail.toString();
    }
}

