/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.simpleframework.xml.core.AttributeException;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.Expression;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.Model;
import org.simpleframework.xml.core.ModelList;
import org.simpleframework.xml.core.ModelMap;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TreeModel
implements Model {
    private final LabelMap attributes;
    private final LabelMap elements;
    private final ModelMap models;
    private final OrderList order;
    private final Policy policy;
    private final String name;
    private final String prefix;
    private final int index;

    public TreeModel(Policy policy) {
        this(policy, null, null, 1);
    }

    public TreeModel(Policy policy, String name, String prefix, int index) {
        this.attributes = new LabelMap(policy);
        this.elements = new LabelMap(policy);
        this.order = new OrderList();
        this.models = new ModelMap();
        this.policy = policy;
        this.prefix = prefix;
        this.index = index;
        this.name = name;
    }

    @Override
    public Model lookup(Expression path) {
        String name = path.getFirst();
        int index = path.getIndex();
        Model model = this.lookup(name, index);
        if (path.isPath()) {
            path = path.getPath(1, 0);
            if (model != null) {
                return model.lookup(path);
            }
        }
        return model;
    }

    @Override
    public void registerElement(String name) throws Exception {
        if (!this.order.contains(name)) {
            this.order.add(name);
        }
        this.elements.put(name, null);
    }

    @Override
    public void registerAttribute(String name) throws Exception {
        this.attributes.put(name, null);
    }

    @Override
    public void registerAttribute(Label label) throws Exception {
        String name = label.getName();
        if (this.attributes.get(name) != null) {
            throw new PersistenceException("Duplicate annotation of name '%s' on %s", name, label);
        }
        this.attributes.put(name, label);
    }

    @Override
    public void registerElement(Label label) throws Exception {
        String name = label.getName();
        if (this.elements.get(name) != null) {
            throw new PersistenceException("Duplicate annotation of name '%s' on %s", name, label);
        }
        if (!this.order.contains(name)) {
            this.order.add(name);
        }
        this.elements.put(name, label);
    }

    @Override
    public ModelMap buildModels(Context context) throws Exception {
        return this.models.build(context);
    }

    @Override
    public LabelMap buildAttributes(Context context) throws Exception {
        return this.attributes.build(context);
    }

    @Override
    public LabelMap buildElements(Context context) throws Exception {
        return this.elements.build(context);
    }

    @Override
    public boolean isModel(String name) {
        return this.models.containsKey(name);
    }

    @Override
    public boolean isElement(String name) {
        return this.elements.containsKey(name);
    }

    @Override
    public boolean isAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    @Override
    public Iterator<String> iterator() {
        ArrayList<String> list = new ArrayList<String>();
        for (String name : this.order) {
            list.add(name);
        }
        return list.iterator();
    }

    @Override
    public void validate(Class type) throws Exception {
        this.validateAttributes(type);
        this.validateElements(type);
        this.validateModels(type);
    }

    private void validateModels(Class type) throws Exception {
        for (ModelList list : this.models) {
            int count = 1;
            for (Model model : list) {
                if (model == null) continue;
                String name = model.getName();
                int index = model.getIndex();
                if (index != count++) {
                    throw new ElementException("Path section '%s[%s]' is out of sequence in %s", name, index, type);
                }
                model.validate(type);
            }
        }
    }

    private void validateAttributes(Class type) throws Exception {
        Set keys = this.attributes.keySet();
        for (String name : keys) {
            Label label = (Label)this.attributes.get(name);
            if (label != null) continue;
            throw new AttributeException("Ordered attribute '%s' does not exist in %s", name, type);
        }
    }

    private void validateElements(Class type) throws Exception {
        Set keys = this.elements.keySet();
        for (String name : keys) {
            ModelList list = (ModelList)this.models.get(name);
            Label label = (Label)this.elements.get(name);
            if (list == null && label == null) {
                throw new ElementException("Ordered element '%s' does not exist in %s", name, type);
            }
            if (list == null || label == null || list.isEmpty()) continue;
            throw new ElementException("Element '%s' is also a path name in %s", name, type);
        }
    }

    @Override
    public void register(Label label) throws Exception {
        if (label.isAttribute()) {
            this.registerAttribute(label);
        } else {
            this.registerElement(label);
        }
    }

    @Override
    public Model lookup(String name, int index) {
        return this.models.lookup(name, index);
    }

    @Override
    public Model register(String name, String prefix, int index) throws Exception {
        Model model = this.models.lookup(name, index);
        if (model == null) {
            return this.create(name, prefix, index);
        }
        return model;
    }

    private Model create(String name, String prefix, int index) throws Exception {
        TreeModel model = new TreeModel(this.policy, name, prefix, index);
        if (name != null) {
            this.models.register(name, model);
            this.order.add(name);
        }
        return model;
    }

    @Override
    public boolean isComposite() {
        for (ModelList list : this.models) {
            for (Model model : list) {
                if (model == null || model.isEmpty()) continue;
                return true;
            }
        }
        return !this.models.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        if (!this.elements.isEmpty()) {
            return false;
        }
        if (!this.attributes.isEmpty()) {
            return false;
        }
        return !this.isComposite();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return String.format("model '%s[%s]'", this.name, this.index);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrderList
    extends ArrayList<String> {
    }
}

