/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.InputNodeMap;
import org.simpleframework.xml.stream.InputPosition;
import org.simpleframework.xml.stream.NodeMap;
import org.simpleframework.xml.stream.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InputAttribute
implements InputNode {
    private InputNode parent;
    private Attribute source;
    private String name;
    private String value;

    public InputAttribute(InputNode parent, Attribute source) {
        this(parent, source, source.getName());
    }

    private InputAttribute(InputNode parent, Attribute source, QName name) {
        this.name = name.getLocalPart();
        this.value = source.getValue();
        this.source = source;
    }

    public InputAttribute(InputNode parent, String name, String value) {
        this.parent = parent;
        this.value = value;
        this.name = name;
    }

    @Override
    public InputNode getParent() {
        return this.parent;
    }

    @Override
    public Position getPosition() {
        return new InputPosition(this.source);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPrefix() {
        return this.source.getName().getPrefix();
    }

    @Override
    public String getReference() {
        return this.source.getName().getNamespaceURI();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isElement() {
        return false;
    }

    @Override
    public InputNode getAttribute(String name) {
        return null;
    }

    @Override
    public NodeMap<InputNode> getAttributes() {
        return new InputNodeMap(this);
    }

    @Override
    public InputNode getNext() {
        return null;
    }

    @Override
    public InputNode getNext(String name) {
        return null;
    }

    @Override
    public void skip() {
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return String.format("attribute %s='%s'", this.name, this.value);
    }
}

