/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Default;
import org.simpleframework.xml.DefaultType;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.AttributeException;
import org.simpleframework.xml.core.Builder;
import org.simpleframework.xml.core.Caller;
import org.simpleframework.xml.core.ClassScanner;
import org.simpleframework.xml.core.Comparer;
import org.simpleframework.xml.core.ConstructorException;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Creator;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.ElementException;
import org.simpleframework.xml.core.FieldScanner;
import org.simpleframework.xml.core.Function;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelFactory;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.MethodScanner;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Reflector;
import org.simpleframework.xml.core.TextException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Scanner {
    private ClassScanner scanner;
    private DefaultType access;
    private LabelMap attributes;
    private LabelMap elements;
    private Comparer comparer;
    private Label version;
    private Label text;
    private String name;
    private Class type;
    private boolean primitive;
    private boolean required;

    public Scanner(Class type) throws Exception {
        this.scanner = new ClassScanner(type);
        this.attributes = new LabelMap(this);
        this.elements = new LabelMap(this);
        this.comparer = new Comparer();
        this.type = type;
        this.scan(type);
    }

    public Class getType() {
        return this.type;
    }

    public Creator getCreator() {
        return this.scanner.getCreator();
    }

    public Decorator getDecorator() {
        return this.scanner.getDecorator();
    }

    public Caller getCaller(Context context) {
        return new Caller(this, context);
    }

    public LabelMap getAttributes(Context context) throws Exception {
        return this.attributes.clone(context);
    }

    public LabelMap getElements(Context context) throws Exception {
        return this.elements.clone(context);
    }

    public Version getRevision() {
        if (this.version != null) {
            return this.version.getContact().getAnnotation(Version.class);
        }
        return null;
    }

    public Label getVersion() {
        return this.version;
    }

    public Label getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public Function getCommit() {
        return this.scanner.getCommit();
    }

    public Function getValidate() {
        return this.scanner.getValidate();
    }

    public Function getPersist() {
        return this.scanner.getPersist();
    }

    public Function getComplete() {
        return this.scanner.getComplete();
    }

    public Function getReplace() {
        return this.scanner.getReplace();
    }

    public Function getResolve() {
        return this.scanner.getResolve();
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    private boolean isEmpty() {
        Root root = this.scanner.getRoot();
        if (!this.elements.isEmpty()) {
            return false;
        }
        if (!this.attributes.isEmpty()) {
            return false;
        }
        if (this.text != null) {
            return false;
        }
        return root == null;
    }

    public boolean isStrict() {
        return this.scanner.isStrict();
    }

    private void scan(Class type) throws Exception {
        this.root(type);
        this.order(type);
        this.access(type);
        this.field(type);
        this.method(type);
        this.validate(type);
    }

    private void validate(Class type) throws Exception {
        Creator creator = this.scanner.getCreator();
        Order order = this.scanner.getOrder();
        this.validateElements(type, order);
        this.validateAttributes(type, order);
        this.validateParameters(creator);
        this.validateText(type);
    }

    private void validateText(Class type) throws Exception {
        if (this.text != null) {
            if (!this.elements.isEmpty()) {
                throw new TextException("Elements used with %s in %s", this.text, type);
            }
        } else {
            this.primitive = this.isEmpty();
        }
    }

    private void validateElements(Class type, Order order) throws Exception {
        Creator factory = this.scanner.getCreator();
        List<Builder> builders = factory.getBuilders();
        for (Builder builder : builders) {
            this.validateConstructor(builder, this.elements);
        }
        if (order != null) {
            for (String name : order.elements()) {
                Label label = (Label)this.elements.get(name);
                if (label != null) continue;
                throw new ElementException("Ordered element '%s' missing for %s", name, type);
            }
        }
    }

    private void validateAttributes(Class type, Order order) throws Exception {
        Creator factory = this.scanner.getCreator();
        List<Builder> builders = factory.getBuilders();
        for (Builder builder : builders) {
            this.validateConstructor(builder, this.elements);
        }
        if (order != null) {
            for (String name : order.attributes()) {
                Label label = (Label)this.attributes.get(name);
                if (label != null) continue;
                throw new AttributeException("Ordered attribute '%s' missing for %s", name, type);
            }
        }
    }

    private void validateConstructor(Builder builder, LabelMap map) throws Exception {
        for (Label label : map) {
            Parameter value;
            if (label == null) continue;
            Contact contact = label.getContact();
            String name = label.getName();
            if (!contact.isReadOnly() || (value = builder.getParameter(name)) != null) continue;
            throw new ConstructorException("No match found for %s in %s", contact, this.type);
        }
    }

    private void validateParameters(Creator creator) throws Exception {
        List<Parameter> list = creator.getParameters();
        for (Parameter parameter : list) {
            String name = parameter.getName();
            Label label = (Label)this.elements.get(name);
            if (this.isEmpty(name)) {
                label = this.text;
            }
            if (label == null) {
                label = (Label)this.attributes.get(name);
            }
            if (label != null) continue;
            throw new ConstructorException("Parameter '%s' does not have a match in %s", name, this.type);
        }
    }

    private void root(Class<?> type) {
        String real = type.getSimpleName();
        Root root = this.scanner.getRoot();
        String text = real;
        if (root != null) {
            text = root.name();
            if (this.isEmpty(text)) {
                text = Reflector.getName(real);
            }
            this.name = text.intern();
        }
    }

    private void order(Class<?> type) {
        Order order = this.scanner.getOrder();
        if (order != null) {
            for (String name : order.elements()) {
                this.elements.put(name, null);
            }
            for (String name : order.attributes()) {
                this.attributes.put(name, null);
            }
        }
    }

    private void access(Class<?> type) {
        Default holder = this.scanner.getDefault();
        if (holder != null) {
            this.required = holder.required();
            this.access = holder.value();
        }
    }

    private boolean isEmpty(String value) {
        return value.length() == 0;
    }

    public void field(Class type) throws Exception {
        FieldScanner list = new FieldScanner(type, this.access, this.required);
        for (Contact contact : list) {
            this.scan(contact, contact.getAnnotation());
        }
    }

    public void method(Class type) throws Exception {
        MethodScanner list = new MethodScanner(type, this.access, this.required);
        for (Contact contact : list) {
            this.scan(contact, contact.getAnnotation());
        }
    }

    private void scan(Contact field, Annotation label) throws Exception {
        if (label instanceof Attribute) {
            this.process(field, label, this.attributes);
        }
        if (label instanceof ElementList) {
            this.process(field, label, this.elements);
        }
        if (label instanceof ElementArray) {
            this.process(field, label, this.elements);
        }
        if (label instanceof ElementMap) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Element) {
            this.process(field, label, this.elements);
        }
        if (label instanceof Version) {
            this.version(field, label);
        }
        if (label instanceof Text) {
            this.text(field, label);
        }
    }

    private void text(Contact field, Annotation type) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        if (this.text != null) {
            throw new TextException("Multiple text annotations in %s", type);
        }
        this.text = label;
    }

    private void version(Contact field, Annotation type) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        if (this.version != null) {
            throw new AttributeException("Multiple version annotations in %s", type);
        }
        this.version = label;
    }

    private void process(Contact field, Annotation type, LabelMap map) throws Exception {
        Label label = LabelFactory.getInstance(field, type);
        String name = label.getName();
        if (map.get(name) != null) {
            throw new PersistenceException("Annotation of name '%s' declared twice", name);
        }
        map.put(name, label);
        this.validate(label, name);
    }

    private void validate(Label field, String name) throws Exception {
        Creator factory = this.scanner.getCreator();
        Parameter parameter = factory.getParameter(name);
        if (parameter != null) {
            this.validate(field, parameter);
        }
    }

    private void validate(Label field, Parameter parameter) throws Exception {
        Contact contact = field.getContact();
        Annotation label = contact.getAnnotation();
        Annotation match = parameter.getAnnotation();
        String name = field.getName();
        if (!this.comparer.equals(label, match)) {
            throw new ConstructorException("Annotation does not match for '%s' in %s", name, this.type);
        }
        Class expect = contact.getType();
        if (expect != parameter.getType()) {
            throw new ConstructorException("Parameter does not match field for '%s' in %s", name, this.type);
        }
    }
}

