/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.convert;

import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.convert.ConverterCache;
import org.simpleframework.xml.convert.Repository;

public class Registry {
    private final ConverterCache cache = new ConverterCache();
    private final Repository store = new Repository();

    public Converter lookup(Class type) throws Exception {
        Converter converter = (Converter)this.cache.fetch(type);
        if (converter == null) {
            return this.create(type);
        }
        return converter;
    }

    private Converter create(Class type) throws Exception {
        Converter converter = this.store.lookup(type);
        if (converter != null) {
            this.cache.cache(type, converter);
        }
        return converter;
    }

    public void bind(Class type, Class converter) throws Exception {
        this.store.bind(type, converter);
    }

    public void bind(Class type, Converter converter) throws Exception {
        this.cache.cache(type, converter);
    }
}

