/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.stream;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.simpleframework.xml.stream.NamespaceMap;
import org.simpleframework.xml.stream.OutputNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrefixResolver
extends LinkedHashMap<String, String>
implements NamespaceMap {
    private final OutputNode source;

    public PrefixResolver(OutputNode source) {
        this.source = source;
    }

    @Override
    public String getPrefix() {
        return this.source.getPrefix();
    }

    @Override
    public String put(String reference) {
        return this.put(reference, "");
    }

    @Override
    public String put(String reference, String prefix) {
        String parent = this.resolve(reference);
        if (parent != null) {
            return null;
        }
        return super.put(reference, prefix);
    }

    @Override
    public String remove(String reference) {
        return (String)super.remove(reference);
    }

    @Override
    public String get(String reference) {
        String prefix;
        int size = this.size();
        if (size > 0 && (prefix = (String)super.get(reference)) != null) {
            return prefix;
        }
        return this.resolve(reference);
    }

    private String resolve(String reference) {
        NamespaceMap parent = this.source.getNamespaces();
        if (parent == null) {
            return null;
        }
        return parent.get(reference);
    }

    @Override
    public Iterator<String> iterator() {
        return this.keySet().iterator();
    }
}

