/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.ConversionInstance;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.Instance;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.strategy.Value;
import org.simpleframework.xml.stream.InputNode;

class MapFactory
extends Factory {
    public MapFactory(Context context, Class field) {
        super(context, field);
    }

    public Object getInstance() throws Exception {
        Class type = this.field;
        if (!MapFactory.isInstantiable(type)) {
            type = this.getConversion(this.field);
        }
        if (!this.isMap(type)) {
            throw new InstantiationException("Type is not a collection %s", this.field);
        }
        return type.newInstance();
    }

    public Instance getInstance(InputNode node) throws Exception {
        Value value = this.getOverride(node);
        if (value != null) {
            return this.getInstance(value);
        }
        if (!MapFactory.isInstantiable(this.field)) {
            this.field = this.getConversion(this.field);
        }
        if (!this.isMap(this.field)) {
            throw new InstantiationException("Type is not a map %s", this.field);
        }
        return this.context.getInstance(this.field);
    }

    public Instance getInstance(Value value) throws Exception {
        Class type = value.getType();
        if (!MapFactory.isInstantiable(type)) {
            type = this.getConversion(type);
        }
        if (!this.isMap(type)) {
            throw new InstantiationException("Type is not a map %s", type);
        }
        return new ConversionInstance(this.context, value, type);
    }

    public Class getConversion(Class type) throws Exception {
        if (type.isAssignableFrom(HashMap.class)) {
            return HashMap.class;
        }
        if (type.isAssignableFrom(TreeMap.class)) {
            return TreeMap.class;
        }
        throw new InstantiationException("Cannot instantiate %s", type);
    }

    private boolean isMap(Class type) {
        return Map.class.isAssignableFrom(type);
    }
}

