/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.EmptyMatcher;
import org.simpleframework.xml.core.Source;
import org.simpleframework.xml.core.Support;
import org.simpleframework.xml.core.Traverser;
import org.simpleframework.xml.filter.Filter;
import org.simpleframework.xml.filter.PlatformFilter;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.NodeBuilder;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;
import org.simpleframework.xml.transform.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persister
implements Serializer {
    private final Strategy strategy;
    private final Support support;
    private final Format format;
    private final Style style;

    public Persister() {
        this(new HashMap());
    }

    public Persister(Format format) {
        this((Strategy)new TreeStrategy(), format);
    }

    public Persister(Map filter) {
        this(new PlatformFilter(filter));
    }

    public Persister(Map filter, Format format) {
        this(new PlatformFilter(filter));
    }

    public Persister(Filter filter) {
        this((Strategy)new TreeStrategy(), filter);
    }

    public Persister(Filter filter, Format format) {
        this((Strategy)new TreeStrategy(), filter, format);
    }

    public Persister(Matcher matcher) {
        this((Strategy)new TreeStrategy(), matcher);
    }

    public Persister(Matcher matcher, Format format) {
        this((Strategy)new TreeStrategy(), matcher, format);
    }

    public Persister(Strategy strategy) {
        this(strategy, new HashMap());
    }

    public Persister(Strategy strategy, Format format) {
        this(strategy, new HashMap(), format);
    }

    public Persister(Filter filter, Matcher matcher) {
        this((Strategy)new TreeStrategy(), filter, matcher);
    }

    public Persister(Filter filter, Matcher matcher, Format format) {
        this(new TreeStrategy(), filter, matcher, format);
    }

    public Persister(Strategy strategy, Map data) {
        this(strategy, new PlatformFilter(data));
    }

    public Persister(Strategy strategy, Map data, Format format) {
        this(strategy, (Filter)new PlatformFilter(data), format);
    }

    public Persister(Strategy strategy, Filter filter) {
        this(strategy, filter, new Format());
    }

    public Persister(Strategy strategy, Filter filter, Format format) {
        this(strategy, filter, new EmptyMatcher(), format);
    }

    public Persister(Strategy strategy, Matcher matcher) {
        this(strategy, (Filter)new PlatformFilter(), matcher);
    }

    public Persister(Strategy strategy, Matcher matcher, Format format) {
        this(strategy, new PlatformFilter(), matcher, format);
    }

    public Persister(Strategy strategy, Filter filter, Matcher matcher) {
        this(strategy, filter, matcher, new Format());
    }

    public Persister(Strategy strategy, Filter filter, Matcher matcher, Format format) {
        this.support = new Support(filter, matcher);
        this.style = format.getStyle();
        this.strategy = strategy;
        this.format = format;
    }

    @Override
    public <T> T read(Class<? extends T> type, String source) throws Exception {
        return (T)this.read((T)type, (Reader)new StringReader(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T read(Class<? extends T> type, File source) throws Exception {
        FileInputStream file = new FileInputStream(source);
        try {
            Class<? extends T> clazz = this.read((T)type, (InputStream)file);
            return (T)clazz;
        }
        finally {
            ((InputStream)file).close();
        }
    }

    @Override
    public <T> T read(Class<? extends T> type, InputStream source) throws Exception {
        return (T)this.read((T)type, source, "utf-8");
    }

    @Override
    public <T> T read(Class<? extends T> type, InputStream source, String charset) throws Exception {
        return (T)this.read((T)type, (Reader)new InputStreamReader(source, charset));
    }

    @Override
    public <T> T read(Class<? extends T> type, Reader source) throws Exception {
        return (T)this.read((T)type, NodeBuilder.read(source));
    }

    public <T> T read(Class<? extends T> type, InputNode source) throws Exception {
        return (T)this.read((T)type, source, this.support);
    }

    private <T> T read(Class<? extends T> type, InputNode node, Support support) throws Exception {
        return (T)this.read((T)type, node, (Context)new Source(this.strategy, support, this.style));
    }

    private <T> T read(Class<? extends T> type, InputNode node, Context context) throws Exception {
        return (T)new Traverser(context).read(node, type);
    }

    @Override
    public <T> T read(T value, String source) throws Exception {
        return this.read(value, (Reader)new StringReader(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T read(T value, File source) throws Exception {
        FileInputStream file = new FileInputStream(source);
        try {
            T t = this.read(value, (InputStream)file);
            return t;
        }
        finally {
            ((InputStream)file).close();
        }
    }

    @Override
    public <T> T read(T value, InputStream source) throws Exception {
        return this.read(value, source, "utf-8");
    }

    @Override
    public <T> T read(T value, InputStream source, String charset) throws Exception {
        return this.read(value, (Reader)new InputStreamReader(source, charset));
    }

    @Override
    public <T> T read(T value, Reader source) throws Exception {
        return this.read(value, NodeBuilder.read(source));
    }

    public <T> T read(T value, InputNode source) throws Exception {
        return this.read(value, source, this.support);
    }

    private <T> T read(T value, InputNode node, Support support) throws Exception {
        return this.read(value, node, (Context)new Source(this.strategy, support, this.style));
    }

    private <T> T read(T value, InputNode node, Context context) throws Exception {
        return (T)new Traverser(context).read(node, value);
    }

    @Override
    public boolean validate(Class type, String source) throws Exception {
        return this.validate(type, new StringReader(source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(Class type, File source) throws Exception {
        FileInputStream file = new FileInputStream(source);
        try {
            boolean bl = this.validate(type, file);
            return bl;
        }
        finally {
            ((InputStream)file).close();
        }
    }

    @Override
    public boolean validate(Class type, InputStream source) throws Exception {
        return this.validate(type, source, "utf-8");
    }

    @Override
    public boolean validate(Class type, InputStream source, String charset) throws Exception {
        return this.validate(type, new InputStreamReader(source, charset));
    }

    @Override
    public boolean validate(Class type, Reader source) throws Exception {
        return this.validate(type, NodeBuilder.read(source));
    }

    public boolean validate(Class type, InputNode source) throws Exception {
        return this.validate(type, source, this.support);
    }

    private boolean validate(Class type, InputNode node, Support support) throws Exception {
        return this.validate(type, node, new Source(this.strategy, support, this.style));
    }

    private boolean validate(Class type, InputNode node, Context context) throws Exception {
        return new Traverser(context).validate(node, type);
    }

    public void write(Object source, OutputNode root) throws Exception {
        this.write(source, root, this.support);
    }

    private void write(Object source, OutputNode root, Support support) throws Exception {
        this.write(source, root, new Source(this.strategy, support, this.style));
    }

    private void write(Object source, OutputNode node, Context context) throws Exception {
        new Traverser(context).write(node, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Object source, File out) throws Exception {
        FileOutputStream file = new FileOutputStream(out);
        try {
            this.write(source, file);
        }
        finally {
            ((OutputStream)file).close();
        }
    }

    @Override
    public void write(Object source, OutputStream out) throws Exception {
        this.write(source, out, "utf-8");
    }

    @Override
    public void write(Object source, OutputStream out, String charset) throws Exception {
        this.write(source, new OutputStreamWriter(out, charset));
    }

    @Override
    public void write(Object source, Writer out) throws Exception {
        this.write(source, NodeBuilder.write(out, this.format));
    }
}

