/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.core.Builder;
import org.simpleframework.xml.core.ClassCreator;
import org.simpleframework.xml.core.Creator;
import org.simpleframework.xml.core.MethodException;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.ParameterFactory;
import org.simpleframework.xml.core.ParameterMap;
import org.simpleframework.xml.core.PersistenceException;

class ConstructorScanner {
    private List<Builder> done = new ArrayList<Builder>();
    private ParameterMap all = new ParameterMap();
    private Builder primary;
    private Class type;

    public ConstructorScanner(Class type) throws Exception {
        this.type = type;
        this.scan(type);
    }

    public Creator getCreator() {
        return new ClassCreator(this.done, this.all, this.primary);
    }

    private void scan(Class type) throws Exception {
        Constructor<?>[] array;
        for (Constructor<?> factory : array = type.getDeclaredConstructors()) {
            ParameterMap map = new ParameterMap();
            if (!factory.isAccessible()) {
                factory.setAccessible(true);
            }
            this.scan(factory, map);
        }
    }

    private void scan(Constructor factory, ParameterMap map) throws Exception {
        Annotation[][] labels = factory.getParameterAnnotations();
        Class<?>[] types = factory.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            for (int j = 0; j < labels[i].length; ++j) {
                Parameter value = this.process(factory, labels[i][j], i);
                if (value == null) continue;
                String name = value.getName();
                if (map.containsKey(name)) {
                    throw new PersistenceException("Parameter '%s' is a duplicate in %s", name, factory);
                }
                this.all.put(name, value);
                map.put(name, value);
            }
        }
        if (types.length == map.size()) {
            this.build(factory, map);
        }
    }

    private void build(Constructor factory, ParameterMap map) throws Exception {
        Builder builder = new Builder(factory, map);
        if (builder.isDefault()) {
            this.primary = builder;
        }
        this.done.add(builder);
    }

    private Parameter process(Constructor factory, Annotation label, int index) throws Exception {
        if (label instanceof Attribute) {
            return this.create(factory, label, index);
        }
        if (label instanceof ElementList) {
            return this.create(factory, label, index);
        }
        if (label instanceof ElementArray) {
            return this.create(factory, label, index);
        }
        if (label instanceof ElementMap) {
            return this.create(factory, label, index);
        }
        if (label instanceof Element) {
            return this.create(factory, label, index);
        }
        return null;
    }

    private Parameter create(Constructor factory, Annotation label, int index) throws Exception {
        Parameter value = ParameterFactory.getInstance(factory, label, index);
        String name = value.getName();
        if (this.all.containsKey(name)) {
            this.validate(value, name);
        }
        return value;
    }

    private void validate(Parameter parameter, String name) throws Exception {
        Parameter other = (Parameter)this.all.get(name);
        Annotation label = other.getAnnotation();
        if (!((Object)parameter.getAnnotation()).equals(label)) {
            throw new MethodException("Annotations do not match for '%s' in %s", name, this.type);
        }
        Class expect = other.getType();
        if (expect != parameter.getType()) {
            throw new MethodException("Method types do not match for '%s' in %s", name, this.type);
        }
    }
}

