/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.beans.Introspector;
import java.lang.reflect.Modifier;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.core.Scanner;
import org.simpleframework.xml.core.ScannerFactory;
import org.simpleframework.xml.core.Support;
import org.simpleframework.xml.core.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

abstract class Factory {
    protected Context context;
    protected Support support;
    protected Class field;

    protected Factory(Context context, Class field) {
        this.support = context.getSupport();
        this.context = context;
        this.field = field;
    }

    public Object getInstance() throws Exception {
        return this.field.newInstance();
    }

    public Type getOverride(InputNode node) throws Exception {
        Class real;
        Type type = this.getConversion(node);
        if (type != null && !Factory.isCompatible(this.field, real = type.getType())) {
            throw new InstantiationException("Type %s is not compatible with %s", real, this.field);
        }
        return type;
    }

    public boolean setOverride(Class field, Object value, OutputNode node) throws Exception {
        if (!field.isPrimitive()) {
            return this.context.setOverride(field, value, node);
        }
        return false;
    }

    public Type getConversion(InputNode node) throws Exception {
        return this.context.getOverride(this.field, node);
    }

    private static Scanner getScanner(Class type) throws Exception {
        return ScannerFactory.getInstance(type);
    }

    public static String getName(Class type) throws Exception {
        Scanner schema = Factory.getScanner(type);
        String name = schema.getName();
        if (name != null) {
            return name;
        }
        return Factory.getClassName(type);
    }

    public static String getClassName(Class type) throws Exception {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        String name = type.getSimpleName();
        if (type.isPrimitive()) {
            return name;
        }
        return Introspector.decapitalize(name);
    }

    public static boolean isCompatible(Class field, Class type) {
        if (field.isArray()) {
            field = field.getComponentType();
        }
        return field.isAssignableFrom(type);
    }

    public static boolean isInstantiable(Class type) {
        int modifiers = type.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            return false;
        }
        return !Modifier.isInterface(modifiers);
    }
}

