/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.core.ArrayFactory;
import org.simpleframework.xml.core.CompositeArray;
import org.simpleframework.xml.core.Contact;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.PrimitiveArray;
import org.simpleframework.xml.core.Qualifier;
import org.simpleframework.xml.core.Signature;
import org.simpleframework.xml.stream.Style;

class ElementArrayLabel
implements Label {
    private Decorator decorator;
    private ElementArray label;
    private Signature detail;
    private Class type;
    private String entry;
    private String name;

    public ElementArrayLabel(Contact contact, ElementArray label) {
        this.detail = new Signature(contact, this);
        this.decorator = new Qualifier(contact);
        this.type = contact.getType();
        this.entry = label.entry();
        this.name = label.name();
        this.label = label;
    }

    public Decorator getDecorator() throws Exception {
        return this.decorator;
    }

    public Converter getConverter(Context context) throws Exception {
        String entry = this.getEntry(context);
        if (!this.type.isArray()) {
            throw new InstantiationException("Type is not an array %s for %s", this.type, this.label);
        }
        return this.getConverter(context, entry);
    }

    private Converter getConverter(Context context, String name) throws Exception {
        Class<?> entry = this.type.getComponentType();
        if (!context.isPrimitive(entry)) {
            return new CompositeArray(context, this.type, entry, name);
        }
        return new PrimitiveArray(context, this.type, entry, name);
    }

    private String getEntry(Context context) throws Exception {
        Style style = context.getStyle();
        String entry = this.getEntry();
        return style.getElement(entry);
    }

    public String getName(Context context) throws Exception {
        Style style = context.getStyle();
        String name = this.detail.getName();
        return style.getElement(name);
    }

    public Object getEmpty(Context context) throws Exception {
        ArrayFactory factory = new ArrayFactory(context, this.type);
        if (!this.label.empty()) {
            return ((Factory)factory).getInstance();
        }
        return null;
    }

    public String getEntry() throws Exception {
        if (this.detail.isEmpty(this.entry)) {
            this.entry = this.detail.getEntry();
        }
        return this.entry;
    }

    public String getName() throws Exception {
        return this.detail.getName();
    }

    public Class getDependant() {
        return this.type.getComponentType();
    }

    public Class getType() {
        return this.type;
    }

    public Contact getContact() {
        return this.detail.getContact();
    }

    public String getOverride() {
        return this.name;
    }

    public boolean isAttribute() {
        return false;
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isData() {
        return this.label.data();
    }

    public boolean isInline() {
        return false;
    }

    public String toString() {
        return this.detail.toString();
    }
}

