/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Converter;
import org.simpleframework.xml.core.Entry;
import org.simpleframework.xml.core.Traverser;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class CompositeValue
implements Converter {
    private final Context context;
    private final Traverser root;
    private final Style style;
    private final Entry entry;
    private final Class type;

    public CompositeValue(Context context, Entry entry, Class type) throws Exception {
        this.root = new Traverser(context);
        this.style = context.getStyle();
        this.context = context;
        this.entry = entry;
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        InputNode next = node.getNext();
        if (next == null) {
            return null;
        }
        if (next.isEmpty()) {
            return null;
        }
        return this.root.read(next, this.type);
    }

    public boolean validate(InputNode node) throws Exception {
        String name = this.entry.getValue();
        if (name == null) {
            name = this.context.getName(this.type);
        }
        return this.validate(node, name);
    }

    private boolean validate(InputNode node, String key) throws Exception {
        String name = this.style.getElement(key);
        InputNode next = node.getNext(name);
        if (next == null) {
            return true;
        }
        if (next.isEmpty()) {
            return true;
        }
        return this.root.validate(next, this.type);
    }

    public void write(OutputNode node, Object item) throws Exception {
        String key = this.entry.getValue();
        if (key == null) {
            key = this.context.getName(this.type);
        }
        String name = this.style.getElement(key);
        this.root.write(node, item, this.type, name);
    }
}

