/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.Map;
import org.simpleframework.xml.Version;
import org.simpleframework.xml.core.Caller;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Decorator;
import org.simpleframework.xml.core.Label;
import org.simpleframework.xml.core.LabelMap;
import org.simpleframework.xml.core.Scanner;
import org.simpleframework.xml.core.Session;

class Schema {
    private Decorator decorator;
    private LabelMap attributes;
    private LabelMap elements;
    private Version revision;
    private Caller caller;
    private Session session;
    private Label version;
    private Label text;
    private Map table;
    private boolean primitive;

    public Schema(Scanner schema, Context context) throws Exception {
        this.attributes = schema.getAttributes(context);
        this.elements = schema.getElements(context);
        this.caller = schema.getCaller(context);
        this.revision = schema.getRevision();
        this.decorator = schema.getDecorator();
        this.primitive = schema.isPrimitive();
        this.session = context.getSession();
        this.version = schema.getVersion();
        this.text = schema.getText();
        this.table = this.session.getMap();
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public Label getVersion() {
        return this.version;
    }

    public Version getRevision() {
        return this.revision;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public Caller getCaller() {
        return this.caller;
    }

    public LabelMap getAttributes() {
        return this.attributes;
    }

    public LabelMap getElements() {
        return this.elements;
    }

    public Label getText() {
        return this.text;
    }
}

