/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Entry;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Primitive;
import org.simpleframework.xml.load.PrimitiveFactory;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;
import org.simpleframework.xml.stream.Style;

class PrimitiveValue
implements Converter {
    private final PrimitiveFactory factory;
    private final Primitive primitive;
    private final Style style;
    private final Entry entry;
    private final Class type;

    public PrimitiveValue(Source root, Entry entry, Class type) {
        this.factory = new PrimitiveFactory(root, type);
        this.primitive = new Primitive(root, type);
        this.style = root.getStyle();
        this.entry = entry;
        this.type = type;
    }

    public Object read(InputNode node) throws Exception {
        String name = this.entry.getValue();
        if (name == null) {
            name = Factory.getName(this.type);
        }
        if (this.entry.isInline()) {
            return this.primitive.read(node);
        }
        return this.read(node, name);
    }

    private Object read(InputNode node, String key) throws Exception {
        String name = this.style.getAttribute(key);
        InputNode child = node.getNext(name);
        if (child == null) {
            return null;
        }
        return this.primitive.read(child);
    }

    public boolean validate(InputNode node) throws Exception {
        String name = this.entry.getValue();
        if (name == null) {
            name = Factory.getName(this.type);
        }
        return this.validate(node, name);
    }

    private boolean validate(InputNode node, String key) throws Exception {
        String name = this.style.getAttribute(key);
        if (!this.entry.isInline() && (node = node.getNext(name)) == null) {
            return true;
        }
        return this.primitive.validate(node);
    }

    public void write(OutputNode node, Object item) throws Exception {
        String name = this.entry.getValue();
        if (name == null) {
            name = Factory.getName(this.type);
        }
        this.write(node, item, name);
    }

    private void write(OutputNode node, Object item, String key) throws Exception {
        String name = this.style.getAttribute(key);
        if (!this.entry.isInline()) {
            node = node.getChild(name);
        }
        if (item != null && !this.isOverridden(node, item)) {
            this.primitive.write(node, item);
        }
    }

    private boolean isOverridden(OutputNode node, Object item) throws Exception {
        return this.factory.setOverride(this.type, item, node);
    }
}

