/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.load.CollectionFactory;
import org.simpleframework.xml.load.CompositeInlineList;
import org.simpleframework.xml.load.CompositeList;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.ElementException;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.PrimitiveInlineList;
import org.simpleframework.xml.load.PrimitiveList;
import org.simpleframework.xml.load.Signature;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.stream.Style;

class ElementListLabel
implements Label {
    private ElementList label;
    private Signature detail;
    private Class type;
    private Class item;
    private String entry;
    private String name;

    public ElementListLabel(Contact contact, ElementList label) {
        this.detail = new Signature(contact, this);
        this.type = contact.getType();
        this.entry = label.entry();
        this.item = label.type();
        this.name = label.name();
        this.label = label;
    }

    public Converter getConverter(Source root) throws Exception {
        String entry = this.getEntry(root);
        if (!this.label.inline()) {
            return this.getConverter(root, entry);
        }
        return this.getInlineConverter(root, entry);
    }

    private Converter getConverter(Source root, String name) throws Exception {
        Class item = this.getDependant();
        if (!Factory.isPrimitive(item)) {
            return new CompositeList(root, this.type, item, name);
        }
        return new PrimitiveList(root, this.type, item, name);
    }

    private Converter getInlineConverter(Source root, String name) throws Exception {
        Class item = this.getDependant();
        if (!Factory.isPrimitive(item)) {
            return new CompositeInlineList(root, this.type, item, name);
        }
        return new PrimitiveInlineList(root, this.type, item, name);
    }

    public String getName(Source source) throws Exception {
        Style style = source.getStyle();
        String name = this.detail.getName();
        return style.getElement(name);
    }

    private String getEntry(Source root) throws Exception {
        Style style = root.getStyle();
        String entry = this.getEntry();
        return style.getElement(entry);
    }

    public Object getEmpty(Source root) throws Exception {
        CollectionFactory factory = new CollectionFactory(root, this.type);
        if (!this.label.empty()) {
            return ((Factory)factory).getInstance();
        }
        return null;
    }

    public Class getDependant() throws Exception {
        Contact contact = this.getContact();
        if (this.item == Void.TYPE) {
            this.item = contact.getDependant();
        }
        if (this.item == null) {
            throw new ElementException("Unable to determine type for %s", this.label);
        }
        return this.item;
    }

    public String getEntry() throws Exception {
        if (this.detail.isEmpty(this.entry)) {
            this.entry = this.detail.getEntry();
        }
        return this.entry;
    }

    public String getName() throws Exception {
        return this.detail.getName();
    }

    public Class getType() {
        return this.type;
    }

    public Contact getContact() {
        return this.detail.getContact();
    }

    public String getOverride() {
        return this.name;
    }

    public boolean isData() {
        return this.label.data();
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isInline() {
        return this.label.inline();
    }

    public String toString() {
        return this.detail.toString();
    }
}

