/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import org.simpleframework.xml.ElementArray;
import org.simpleframework.xml.load.ArrayFactory;
import org.simpleframework.xml.load.CompositeArray;
import org.simpleframework.xml.load.Contact;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Factory;
import org.simpleframework.xml.load.InstantiationException;
import org.simpleframework.xml.load.Label;
import org.simpleframework.xml.load.PrimitiveArray;
import org.simpleframework.xml.load.Signature;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.stream.Style;

class ElementArrayLabel
implements Label {
    private ElementArray label;
    private Signature detail;
    private Class type;
    private String entry;
    private String name;

    public ElementArrayLabel(Contact contact, ElementArray label) {
        this.detail = new Signature(contact, this);
        this.type = contact.getType();
        this.entry = label.entry();
        this.name = label.name();
        this.label = label;
    }

    public Converter getConverter(Source root) throws Exception {
        String entry = this.getEntry(root);
        if (!this.type.isArray()) {
            throw new InstantiationException("Type is not an array %s for %s", this.type, this.label);
        }
        return this.getConverter(root, entry);
    }

    private Converter getConverter(Source root, String name) throws Exception {
        Class<?> entry = this.type.getComponentType();
        if (!Factory.isPrimitive(entry)) {
            return new CompositeArray(root, this.type, entry, name);
        }
        return new PrimitiveArray(root, this.type, entry, name);
    }

    private String getEntry(Source root) throws Exception {
        Style style = root.getStyle();
        String entry = this.getEntry();
        return style.getElement(entry);
    }

    public String getName(Source source) throws Exception {
        Style style = source.getStyle();
        String name = this.detail.getName();
        return style.getElement(name);
    }

    public Object getEmpty(Source root) throws Exception {
        ArrayFactory factory = new ArrayFactory(root, this.type);
        if (!this.label.empty()) {
            return ((Factory)factory).getInstance();
        }
        return null;
    }

    public String getEntry() throws Exception {
        if (this.detail.isEmpty(this.entry)) {
            this.entry = this.detail.getEntry();
        }
        return this.entry;
    }

    public String getName() throws Exception {
        return this.detail.getName();
    }

    public Class getDependant() {
        return this.type.getComponentType();
    }

    public Class getType() {
        return this.type;
    }

    public Contact getContact() {
        return this.detail.getContact();
    }

    public String getOverride() {
        return this.name;
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isData() {
        return this.label.data();
    }

    public boolean isInline() {
        return false;
    }

    public String toString() {
        return this.detail.toString();
    }
}

