/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.load;

import java.util.Collection;
import org.simpleframework.xml.load.CollectionFactory;
import org.simpleframework.xml.load.Converter;
import org.simpleframework.xml.load.Primitive;
import org.simpleframework.xml.load.Source;
import org.simpleframework.xml.load.Type;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

class PrimitiveList
implements Converter {
    private final CollectionFactory factory;
    private final Primitive root;
    private final String parent;
    private final Class entry;

    public PrimitiveList(Source root, Class type, Class entry, String parent) {
        this.factory = new CollectionFactory(root, type);
        this.root = new Primitive(root, entry, null);
        this.parent = parent;
        this.entry = entry;
    }

    public Object read(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        Object list = type.getInstance();
        if (!type.isReference()) {
            return this.read(node, list);
        }
        return list;
    }

    private Object read(InputNode node, Object result) throws Exception {
        Collection list = (Collection)result;
        InputNode next;
        while ((next = node.getNext()) != null) {
            list.add(this.root.read(next));
        }
        return list;
    }

    public boolean validate(InputNode node) throws Exception {
        Type type = this.factory.getInstance(node);
        if (!type.isReference()) {
            Object real = type.getInstance(type);
            Class expect = type.getType();
            return this.validate(node, expect);
        }
        return true;
    }

    private boolean validate(InputNode node, Class type) throws Exception {
        InputNode next;
        while ((next = node.getNext()) != null) {
            this.root.validate(next);
        }
        return true;
    }

    public void write(OutputNode node, Object source) throws Exception {
        Collection list = (Collection)source;
        for (Object item : list) {
            OutputNode child;
            if (item == null || this.isOverridden(child = node.getChild(this.parent), item)) continue;
            this.root.write(child, item);
        }
    }

    private boolean isOverridden(OutputNode node, Object value) throws Exception {
        return this.factory.setOverride(this.entry, value, node);
    }
}

